package net.sf.amateras.air.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * abstract Compiler
 * 
 * @author ogawahideko
 */
public class Compiler {

	protected IProject project;
	protected Map<String, String> idMap = new HashMap<String, String>();
	protected Pattern pattern;
	protected Pattern targetNotFoundPattern;

	public Compiler(IProject project, Pattern pattern, Pattern targetNotFoundPattern) {
		this.project = project;
		this.pattern = pattern;
		this.targetNotFoundPattern = targetNotFoundPattern;
	}

	public void setMessagePattern(Pattern pattern) {
		this.pattern = pattern;
	}

	public void setTargetNotFoundPattern(Pattern pattern) {
		this.targetNotFoundPattern = pattern;
	}

	public void dispose() {
		project = null;
		pattern = null;
		targetNotFoundPattern = null;
		idMap.clear();
	}

	public String compile(String name, FcshShell fcsh, IProgressMonitor monitor) throws CoreException {
		String firstCommand = name;
		String command = firstCommand;
		if (idMap.containsKey(firstCommand)) {
			String id = idMap.get(firstCommand);
			command = "compile " + id + "\n";
		}
		String result = execute(firstCommand, command, fcsh, monitor);
		project.refreshLocal(IResource.DEPTH_INFINITE, null);
		return result;
	}

	private String execute(String firstCommand, String command, FcshShell fcsh, IProgressMonitor monitor) {
		monitor.setTaskName(String.format(AIRPlugin.getResourceString("COMPILE_START_COMPILE"), command));
		String result = fcsh.startCommand(command, monitor);
		Matcher matcher = pattern.matcher(result);
		if (matcher.find()) {
			String id = matcher.group(1);
			idMap.put(command, id);
		} else if (!firstCommand.equals(command)) {
			matcher = targetNotFoundPattern.matcher(result);
			if (matcher.find()) {
				idMap.remove(command);
				return execute(firstCommand, firstCommand, fcsh, monitor);
			}
		}

		return result;
	}
}
