package net.sf.amateras.air.mxml;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.models.AccordionModel;
import net.sf.amateras.air.mxml.models.ApplicationControlBarModel;
import net.sf.amateras.air.mxml.models.ApplicationModel;
import net.sf.amateras.air.mxml.models.BoxModel;
import net.sf.amateras.air.mxml.models.ButtonModel;
import net.sf.amateras.air.mxml.models.CanvasModel;
import net.sf.amateras.air.mxml.models.CheckBoxModel;
import net.sf.amateras.air.mxml.models.ColorPickerModel;
import net.sf.amateras.air.mxml.models.ComboBoxModel;
import net.sf.amateras.air.mxml.models.ControlBarModel;
import net.sf.amateras.air.mxml.models.DataGridColumnModel;
import net.sf.amateras.air.mxml.models.DateFieldModel;
import net.sf.amateras.air.mxml.models.FileSystemComboBoxModel;
import net.sf.amateras.air.mxml.models.FileSystemHistoryButtonModel;
import net.sf.amateras.air.mxml.models.FileSystemListModel;
import net.sf.amateras.air.mxml.models.FileSystemTreeModel;
import net.sf.amateras.air.mxml.models.HBoxModel;
import net.sf.amateras.air.mxml.models.HDividedBoxModel;
import net.sf.amateras.air.mxml.models.HtmlModel;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.IModel;
import net.sf.amateras.air.mxml.models.ImageModel;
import net.sf.amateras.air.mxml.models.LabelModel;
import net.sf.amateras.air.mxml.models.LinkButtonModel;
import net.sf.amateras.air.mxml.models.ListModel;
import net.sf.amateras.air.mxml.models.PanelModel;
import net.sf.amateras.air.mxml.models.PopUpButtonModel;
import net.sf.amateras.air.mxml.models.RadioButtonModel;
import net.sf.amateras.air.mxml.models.RichTextEditorModel;
import net.sf.amateras.air.mxml.models.RootModel;
import net.sf.amateras.air.mxml.models.SWFLoaderModel;
import net.sf.amateras.air.mxml.models.SpacerModel;
import net.sf.amateras.air.mxml.models.TabNavigatorModel;
import net.sf.amateras.air.mxml.models.TextAreaModel;
import net.sf.amateras.air.mxml.models.TextInputModel;
import net.sf.amateras.air.mxml.models.TextModel;
import net.sf.amateras.air.mxml.models.TitleWindowModel;
import net.sf.amateras.air.mxml.models.TreeModel;
import net.sf.amateras.air.mxml.models.VBoxModel;
import net.sf.amateras.air.mxml.models.VDividedBoxModel;
import net.sf.amateras.air.mxml.models.VideoDisplayModel;
import net.sf.amateras.air.mxml.models.ViewStackModel;
import net.sf.amateras.air.mxml.models.WindowModel;
import net.sf.amateras.air.mxml.models.WindowedApplicationModel;
import net.sf.amateras.air.mxml.parser.AbstractMXMLParser;
import net.sf.amateras.air.mxml.parser.DataGridParser;
import net.sf.amateras.air.mxml.parser.DefaultMXMLParser;
import net.sf.amateras.air.mxml.parser.FileSystemDataGridParser;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * Converts MXML to visual models using {@link AbstractMXMLParser}s.
 * 
 * @see DefaultMXMLParser
 * @author Naoki Takezoe
 */
public class MXMLLoader {

	private MXMLLoader() {

	}

	private static Map<String, AbstractMXMLParser> parsers = new HashMap<String, AbstractMXMLParser>();
	static {
		parsers.put("Label", new DefaultMXMLParser(LabelModel.class));
		parsers.put("Text", new DefaultMXMLParser(TextModel.class));
		parsers.put("Button", new DefaultMXMLParser(ButtonModel.class));
		parsers.put("TextArea", new DefaultMXMLParser(TextAreaModel.class));
		parsers.put("TextInput", new DefaultMXMLParser(TextInputModel.class));
		parsers.put("DateField", new DefaultMXMLParser(DateFieldModel.class));
		parsers.put("LinkButton", new DefaultMXMLParser(LinkButtonModel.class));
		parsers.put("Image", new DefaultMXMLParser(ImageModel.class));
		parsers.put("CheckBox", new DefaultMXMLParser(CheckBoxModel.class));
		parsers.put("ComboBox", new DefaultMXMLParser(ComboBoxModel.class));
		parsers.put("FileSystemComboBox", new DefaultMXMLParser(FileSystemComboBoxModel.class));
		parsers.put("PopUpButton", new DefaultMXMLParser(PopUpButtonModel.class));
		parsers.put("FileSystemHistoryButton", new DefaultMXMLParser(FileSystemHistoryButtonModel.class));
		parsers.put("List", new DefaultMXMLParser(ListModel.class));
		parsers.put("FileSystemList", new DefaultMXMLParser(FileSystemListModel.class));
		parsers.put("DataGrid", new DataGridParser());
		parsers.put("FileSystemDataGrid", new FileSystemDataGridParser());
		parsers.put("RadioButton", new DefaultMXMLParser(RadioButtonModel.class));
		parsers.put("HTML", new DefaultMXMLParser(HtmlModel.class));
		parsers.put("VideoDisplay", new DefaultMXMLParser(VideoDisplayModel.class));
		parsers.put("SWFLoader", new DefaultMXMLParser(SWFLoaderModel.class));
		parsers.put("RichTextEditor", new DefaultMXMLParser(RichTextEditorModel.class));
		parsers.put("Tree", new DefaultMXMLParser(TreeModel.class));
		parsers.put("FileSystemTree", new DefaultMXMLParser(FileSystemTreeModel.class));
		parsers.put("ColorPicker", new DefaultMXMLParser(ColorPickerModel.class));
		parsers.put("Spacer", new DefaultMXMLParser(SpacerModel.class));

		//Layout
		parsers.put("WindowedApplication", new DefaultMXMLParser(WindowedApplicationModel.class));
		parsers.put("Application", new DefaultMXMLParser(ApplicationModel.class));
		parsers.put("TitleWindow", new DefaultMXMLParser(TitleWindowModel.class));
		parsers.put("Window", new DefaultMXMLParser(WindowModel.class));
		parsers.put("Box", new DefaultMXMLParser(BoxModel.class));
		parsers.put("VBox", new DefaultMXMLParser(VBoxModel.class));
		parsers.put("HBox", new DefaultMXMLParser(HBoxModel.class));
		parsers.put("HDividedBox", new DefaultMXMLParser(HDividedBoxModel.class));
		parsers.put("VDividedBox", new DefaultMXMLParser(VDividedBoxModel.class));
		parsers.put("ControlBar", new DefaultMXMLParser(ControlBarModel.class));
		parsers.put("ApplicationControlBar", new DefaultMXMLParser(ApplicationControlBarModel.class));
		parsers.put("Panel", new DefaultMXMLParser(PanelModel.class));
		parsers.put("Accordion", new DefaultMXMLParser(AccordionModel.class));
		parsers.put("Canvas", new DefaultMXMLParser(CanvasModel.class));
		parsers.put("TabNavigator", new DefaultMXMLParser(TabNavigatorModel.class));
		parsers.put("ViewStack", new DefaultMXMLParser(ViewStackModel.class));

		// out of ui
		parsers.put("DataGridColumn", new DefaultMXMLParser(DataGridColumnModel.class));
	}

	/**
	 * load MXML
	 * @param in
	 * @return
	 */
	public static IModel loadMXML(InputStream in, RootModel root) {
		try {
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
			Document doc = builder.parse(in);

			IModel child = parseElement(root, doc.getDocumentElement());
			return child;

		} catch (Exception ex) {
			AIRPlugin.logException(ex);
			return new RootModel();
		}
	}

	/**
	 * get parser for elementName.
	 * @param elementName
	 * @return AbstractMXMLParser
	 */
	public static AbstractMXMLParser getParser(String elementName) {
		String prefix = AIRPlugin.getDefault().getNameSpacePrefix();
		if (prefix != null) {
			if (elementName.startsWith(prefix)) {
				elementName = elementName.substring(prefix.length());
			}
		}
		return parsers.get(elementName);
	}

	/**
	 * parse Element property.
	 * if root is IContainerModel, add child.
	 * @param root
	 * @param e
	 * @return
	 */
	public static IModel parseElement(IModel root, Element e) {
		String elementName = e.getTagName();
		AbstractMXMLParser parser = MXMLLoader.getParser(elementName);

		if (parser != null) {
			ElementWrapper element = new ElementWrapper(e);
			IModel model = null;
			if (root instanceof IContainerModel) {
				model = parser.parse(element, (IContainerModel) root);
				((IContainerModel) root).addChild((IComponentModel) model);
				return model;
			} else {
				model = parser.parse(element, null);
				if (root != null) {
					root.addAdditionalChildElement(e);
				}
				return model;
			}

		} else if (elementName.equals(AIRPlugin.getDefault().getNameSpacePrefix() + "Script")
				&& root instanceof IContainerModel) {
			String script = e.getAttribute("source");
			if (script != null && script.length() > 0) {
				((IContainerModel) root).addScript(e.getAttribute("source"));
			} else {
				root.addAdditionalChildElement(e);
			}
			return null;
		} else {
			root.addAdditionalChildElement(e);
			return null;
		}
	}

}
