package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.editparts.policy.TextDirectEditPolicy;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.jface.viewers.TextCellEditor;

/**
 * EditPart for DirectEdit Text.
 * 
 * @author ogawahideko
 */
public abstract class AbstractDirectEditPart extends AbstractComponentEditPart {

	private TextDirectEditManager directManager = null;

	protected abstract String getDirectEditPropertyKey();

	protected IFigure getDirectEditFigure() {
		return getFigure();
	}

	@Override
	public void performRequest(Request req) {
		if (req.getType().equals(RequestConstants.REQ_DIRECT_EDIT)) {
			performDirectEdit();
			return;
		}
		super.performRequest(req);
	}

	private void performDirectEdit() {
		if (directManager == null) {
			directManager = new TextDirectEditManager(this, TextCellEditor.class, new TextCellEditorLocator(
					getDirectEditFigure()), getDirectEditPropertyKey());
		}
		directManager.show();
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new TextDirectEditPolicy(getDirectEditPropertyKey()));
	}

}
