package net.sf.amateras.air.mxml.editparts;

import java.util.List;

import net.sf.amateras.air.mxml.editparts.policy.ResizeableFlowLayoutEditPolicy;
import net.sf.amateras.air.mxml.figures.AccordionFigure;
import net.sf.amateras.air.mxml.models.AbstractContainerModel;
import net.sf.amateras.air.mxml.models.AccordionModel;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;

/**
 * The editpart for the {@link AccordionModel}.
 * @author ogawahideko
 *
 */
public class AccordionEditPart extends AbstractComponentEditPart {
	@Override
	protected IFigure createFigure() {
		AccordionFigure figure = new AccordionFigure();
		updateFigure((AccordionModel) getModel(), figure);
		return figure;
	}

	@Override
	protected List<IComponentModel> getModelChildren() {
		return ((IContainerModel) getModel()).getChildren();
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new ResizeableFlowLayoutEditPolicy());
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		AccordionModel model = (AccordionModel) getModel();
		AccordionFigure figure = (AccordionFigure) getFigure();
		updateFigure(model, figure);
	}

	@Override
	public void refresh() {
		super.refresh();
		AccordionModel model = (AccordionModel) getModel();
		AccordionFigure figure = (AccordionFigure) getFigure();
		//if (figure.getSelectIndex() == -1) {
		try {
			int index = model.getSelectedIndex();
			if (index < 0) {
				index = model.getAttributeToNumber(AccordionModel.SELECTED_INDEX);
			}
			figure.setSelectedIndex(index);
		} catch (NumberFormatException e) {
			//Nothing todo.
		}
		//}
	}

	@Override
	protected void addChildVisual(EditPart childEditPart, int index) {
		IFigure child = ((GraphicalEditPart) childEditPart).getFigure();
		String title = "";
		if (childEditPart.getModel() instanceof AbstractContainerModel) {
			title = ((AbstractContainerModel) childEditPart.getModel())
					.getAttributeToString(AbstractContainerModel.LABEL);
		}

		((AccordionFigure) getFigure()).add(child, title, child.getBounds(), index);
	}

	@Override
	protected void removeChildVisual(EditPart childEditPart) {
		IFigure child = ((GraphicalEditPart) childEditPart).getFigure();
		getFigure().remove(child);
	}

	private void updateFigure(AccordionModel model, AccordionFigure figure) {
		figure.setToolTip(new Label(model.toString()));
		try {
			int top = model.getAttributeToNumber(AccordionModel.PADDING_TOP);
			int left = model.getAttributeToNumber(AccordionModel.PADDING_LEFT);
			int right = model.getAttributeToNumber(AccordionModel.PADDING_RIGHT);
			int bottom = model.getAttributeToNumber(AccordionModel.PADDING_BOTTOM);
			figure.setPadding(new Insets(top, left, bottom, right));
		} catch (NumberFormatException ex) {
			//Nothing todo.
		}

		figure.revalidate();
	}

	@Override
	public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
		// Nothing todo.
	}

}
