package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.ColorPicker;
import net.sf.amateras.air.mxml.models.CheckBoxModel;
import net.sf.amateras.air.mxml.models.ColorPickerModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link CheckBoxModel}.
 * 
 * @author ogawahideko
 */
public class ColorPickerEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		ColorPicker button = new ColorPicker();
		updateFigure(button, (ColorPickerModel) getModel());
		return button;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((ColorPicker) getFigure(), (ColorPickerModel) getModel());
	}

	private void updateFigure(ColorPicker button, ColorPickerModel model) {
		button.setToolTip(new Label(model.toString()));
	}

}
