package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.BoxFigure;
import net.sf.amateras.air.mxml.models.HtmlModel;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;

/**
 * The editpart for the {@link HtmlModel}.
 * 
 * @author ogawahideko
 */
public class HtmlEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		BoxFigure box = new BoxFigure();
		updateFigure(box, (HtmlModel) getModel());
		return box;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((BoxFigure) getFigure(), (HtmlModel) getModel());
	}

	private void updateFigure(BoxFigure figure, HtmlModel model) {
		figure.setToolTip(new Label(model.toString()));
		figure.setBorder(new LineBorder(ColorConstants.lightGray));

		figure.repaint();
	}

}
