package net.sf.amateras.air.mxml.editparts.command;

import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;

import org.eclipse.gef.commands.Command;

/**
 * AddCommand for AbstractComponentModel.
 * @author Hideko Ogawa
 *
 */
public class AddCommand extends Command {

	protected IComponentModel model;
	protected IContainerModel root;
	protected IContainerModel oldRoot;
	protected FlexRectangle rectangle;

	protected int beforeIndex;
	protected int addIndex;

	public AddCommand(IContainerModel root, IComponentModel model, IComponentModel afterModel, FlexRectangle rectangle) {
		this.root = root;
		this.model = model;
		oldRoot = model.getRoot();
		beforeIndex = oldRoot.getChildIndex(model);
		this.rectangle = rectangle;

		if (afterModel != null) {
			addIndex = root.getChildIndex(afterModel);
		}
	}

	@Override
	public void execute() {
		model.setConstraint(rectangle);
		//oldRoot.removeChild(model);
		if (addIndex > 0) {
			root.addChild(addIndex, model);
		} else {
			root.addChild(model);
		}
	}

	@Override
	public void undo() {
		//oldRoot.addChild(beforeIndex, model);
		root.removeChild(model);
	}

	@Override
	public boolean canExecute() {
		if (root == null) {
			return false;
		}
		return root.canChildComponent(model);
	}

}
