package net.sf.amateras.air.mxml.editparts.policy;

import net.sf.amateras.air.mxml.editparts.command.AddCommand;
import net.sf.amateras.air.mxml.editparts.command.ChangeConstraintCommand;
import net.sf.amateras.air.mxml.editparts.command.CreateCommand;
import net.sf.amateras.air.mxml.editparts.command.OrphanChildrenCommand;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;

/**
 * XYLayoutPolicy impl.
 * 
 * @author ogawahideko
 *
 */
public class RootEditPolicy extends XYLayoutEditPolicy {

	@Override
	protected EditPolicy createChildEditPolicy(EditPart child) {
		return new ResizableEditPolicy() {
			@Override
			protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
				IFigure feedback = getDragSourceFeedbackFigure();

				PrecisionRectangle rect = new PrecisionRectangle(getInitialFeedbackBounds().getCopy());
				getHostFigure().translateToAbsolute(rect);
				rect.translate(request.getMoveDelta());
				rect.resize(request.getSizeDelta());
				snapToGrid(rect);

				feedback.translateToRelative(rect);
				feedback.setBounds(rect);
			}
		};
	}

	@Override
	protected void showSizeOnDropFeedback(CreateRequest request) {
		Point p = new Point(request.getLocation().getCopy());
		IFigure feedback = getSizeOnDropFeedback(request);
		feedback.translateToRelative(p);
		Dimension size = request.getSize().getCopy();
		feedback.translateToRelative(size);

		Rectangle rectangle = new Rectangle(p, size).expand(getCreationFeedbackOffset(request));
		snapToGrid(rectangle);

		feedback.setBounds(rectangle);
	}

	@Override
	protected Command createAddCommand(EditPart child, Object constraint) {
		IContainerModel root = (IContainerModel) getHost().getModel();
		IComponentModel childModel = (IComponentModel) child.getModel();
		Rectangle rectangle = (Rectangle) constraint;
		snapToGrid(rectangle);
		FlexRectangle fr = new FlexRectangle();
		fr.setRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
		return new AddCommand(root, childModel, null, fr);
	}

	@Override
	protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
		Rectangle rectangle = (Rectangle) constraint;
		snapToGrid(rectangle);

		ChangeConstraintCommand command = new ChangeConstraintCommand();
		command.setModel((IComponentModel) child.getModel());
		FlexRectangle fr = new FlexRectangle();
		fr.setRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
		command.setConstraint(fr);
		return command;
	}

	@Override
	protected Command getCreateCommand(CreateRequest request) {
		Rectangle rectangle = (Rectangle) getConstraintFor(request);
		snapToGrid(rectangle);
		IContainerModel root = (IContainerModel) getHost().getModel();
		FlexRectangle fr = new FlexRectangle();
		fr.setRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
		return new CreateCommand(root, request, fr);
	}

	@Override
	protected Command getDeleteDependantCommand(Request request) {
		return null;
	}

	@Override
	@SuppressWarnings("unchecked")
	protected Command getOrphanChildrenCommand(Request request) {
		GroupRequest gRequest = (GroupRequest) request;
		return new OrphanChildrenCommand(gRequest.getEditParts());
	}

	@Override
	protected Object translateToModelConstraint(Object figureConstraint) {
		if (figureConstraint instanceof FlexRectangle) {
			FlexRectangle fr = (FlexRectangle) figureConstraint;
			fr.setX(fr.x);
			fr.setY(fr.y);
			fr.setWidth(fr.width);
			fr.setHeight(fr.height);
		}
		return super.translateToModelConstraint(figureConstraint);
	}

	protected void snapToGrid(Rectangle rectangle) {
		rectangle.x = roundValue(rectangle.x);
		rectangle.y = roundValue(rectangle.y);
		rectangle.width = roundValue(rectangle.width);
		rectangle.height = roundValue(rectangle.height);
	}

	private int roundValue(int value) {
		int div = value % 10;
		if (div >= 5) {
			return value + (10 - div);
		} else {
			return value - div;
		}
	}
}
