package net.sf.amateras.air.mxml.models;

import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ColorUtil;

/**
 * An abstract class for mx.core.Container models.
 * @author ogawahideko
 *
 */
public abstract class AbstractContainerModel extends AbstractViewModel implements IContainerModel {
	public static final String PACKAGE_NAME = "mx.containers";
	public static final String KEY_CHILDREN = "_children";
	public static final String KEY_SCRIPT = "_script";

	//properties
	public static final String NAMESPACE = "xmlns:mx";
	public static final String HORIZONTAL_LINE_SCROLL_SIZE = "horizontalLineScrollSize";
	public static final String HORIZONTAL_PAGE_SCROLL_SIZE = "horizontalPageScrollSize";
	public static final String HORIZONTAL_SCROLL_POLICY = "horizontalScrollPolicy";
	public static final String HORIZONTAL_SCROLL_POSITION = "horizontalScrollPosition";

	public static final String ICON = "icon";
	public static final String LABEL = "label";

	public static final String VERTICAL_LINE_SCROLL_SIZE = "verticalLineScrollSize";
	public static final String VERTICAL_PAGE_SCROLL_SIZE = "verticalPageScrollSize";
	public static final String VERTICAL_SCROLL_POLICY = "verticalScrollPolicy";
	public static final String VERTICAL_SCROLL_POSITION = "verticalScrollPosition";

	//Styles
	public static final String BACKGROUND_COLOR = "backgroundColor";
	public static final String BORDER_COLOR = "borderColor";
	public static final String COLOR = "color";
	public static final String DISABLED_COLOR = "disabledColor";

	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_WEIGHT = "fontWeight";

	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String PADDING_TOP = "paddingTop";

	private List<String> script = new ArrayList<String>();

	//private Element scriptElement;

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(NAMESPACE, CATEGORY_PROPERTY, "http://www.adobe.com/2006/mxml");

		addStringModelProperty(LABEL, CATEGORY_PROPERTY);
		addNumberModelProperty(HORIZONTAL_LINE_SCROLL_SIZE, CATEGORY_PROPERTY, 5);
		addNumberModelProperty(HORIZONTAL_PAGE_SCROLL_SIZE, CATEGORY_PROPERTY, 0);
		addListModelProperty(HORIZONTAL_SCROLL_POLICY, CATEGORY_PROPERTY, new String[] { "auto", "on", "off" });
		addNumberModelProperty(HORIZONTAL_SCROLL_POSITION, CATEGORY_PROPERTY, 0);

		addNumberModelProperty(VERTICAL_LINE_SCROLL_SIZE, CATEGORY_PROPERTY, 5);
		addNumberModelProperty(VERTICAL_PAGE_SCROLL_SIZE, CATEGORY_PROPERTY, 0);
		addListModelProperty(VERTICAL_SCROLL_POLICY, CATEGORY_PROPERTY, new String[] { "auto", "on", "off" });
		addNumberModelProperty(VERTICAL_SCROLL_POSITION, CATEGORY_PROPERTY, 0);

		//Styles
		addColorModelProperty(BACKGROUND_COLOR, CATEGORY_STYLE);
		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3"));
		addColorModelProperty(COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#0B333C"));
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3"));

		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana");
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 10);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, new String[] { "normal", "italic" });
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, new String[] { "normal", "bold" });

		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 0);

	}

	@Override
	public void addChild(int index, IComponentModel child) {
		child.setRoot(this);
		super.addChild(index, child);
	}

	// to XML
	// ----------------------------------------
	@Override
	protected String getChildAllNodeXML() {
		StringBuilder sb = new StringBuilder();
		for (String s : script) {
			sb.append("<").append(AIRPlugin.getDefault().getNameSpacePrefix()).append("Script source=\"").append(s)
					.append("\"/>\n");
		}

		sb.append(super.getChildAllNodeXML());

		return sb.toString();
	}

	public String getScript() {
		if (this.script != null && this.script.size() > 0) {
			return script.get(0);
		} else {
			return null;
		}
	}

	@Override
	public void addScript(String script) {
		this.script.add(script);
		firePropertyChange(KEY_SCRIPT, null, script);
	}

	/**
	 * Whether it is possible to add it as a child component or not?
	 * If it is AbstractComponentModel and not IDecidedParentComonent, it is OK.
	 * @param model
	 * @return
	 */
	@Override
	public boolean canChildComponent(Object model) {
		if (model == null) {
			return false;
		} else if (model instanceof IComponentModel) {
			return model instanceof IDecidedParentComonent ? false : true;
		} else {
			return false;
		}
	}

	/**
	 * return to FlexModel pakage name.
	 * 
	 * @return
	 */
	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

	/**
	 * return flex model name.
	 * @return
	 */
	public String getFlexModelName() {
		return getFlexModelPackageName() + "." + getComponentName();
	}

	@Override
	public int getChildIndex(IComponentModel child) {
		for (int i = 0; i < getChildren().size(); i++) {
			if (child == getChildren().get(i)) {
				return i;
			}
		}
		return -1;
	}

}
