package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * model of mx.controls.ColorPicker
 * 
 * @author ogawahideko
 * 
 */
public class ColorPickerModel extends AbstractComboBase {

	public static final String COMPONENT_NAME = "ColorPicker";

	//properties
	public static final String COLOR_FIELD = "colorField";
	public static final String LABEL_FIELD = "labelField";
	public static final String SELECTED_COLOR = "selectedColor";
	public static final String SELECTED_INDEX = "selectedIndex";
	public static final String SHOW_TEXT_FIELD = "showTextField";

	//styles
	public static final String BORDER_COLOR = "borderColor";
	public static final String CLOSE_DURATION = "closeDuration";
	public static final String CLOSE_EASING_FUNCTION = "closeEasingFunction";
	public static final String COLOR = "color";
	public static final String DISABLED_COLOR = "disabledColor";
	public static final String DISABLED_ICON_COLOR = "disabledIconColor";
	public static final String FILL_ALPHAS = "fillAlphas";
	public static final String FILL_COLORS = "fillColors";
	public static final String FOCUS_ALPHA = "focusAlpha";
	public static final String FOCUS_ROUNDED_CORNERS = "focusRoundedCorners";
	public static final String FONT_ANTI_ALIAS_TYPE = "fontAntiAliasType";
	public static final String FONT_FAMILY = "fontfamily";
	public static final String FONT_GRID_FIT_TYPE = "fontGridFitType";
	public static final String FONT_SHARPNESS = "fontSharpness";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_THICKNESS = "fontThickness";
	public static final String FONT_WEIGHT = "fontWeight";
	public static final String HIGHLIGHT_ALPHAS = "highlightAlphas";
	public static final String ICON_COLOR = "iconColor";
	public static final String KERNING = "kerning";
	public static final String LEADING = "leading";
	public static final String LETTER_SPACING = "letterSpacing";
	public static final String OPEN_DURATION = "openDuration";
	public static final String OPEN_EASING_FUNCTION = "openEasingFunction";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String PADDING_TOP = "paddingTop";
	public static final String SWATCH_BORDER_COLOR = "swatchBorderColor";
	public static final String SWATCH_BORDER_SIZE = "swatchBorderSize";
	public static final String SWATCH_PANEL_STYLE_NAME = "swatchPanelStyleName";
	public static final String TEXT_ALIGN = "textAlign";
	public static final String TEXT_DECORATION = "textDecoration";
	public static final String TEXT_INDENT = "textIndent";

	// events
	public static final String CHANGE = "change";
	public static final String CLOSE = "close";
	public static final String ENTER = "enter";
	public static final String OPEN = "open";
	public static final String ITEM_ROLL_OVER = "itemRollOver";
	public static final String ITEM_ROLL_OUT = "itemRollOut";

	private static final int CLOSE_DULATION_DEFALUT_VALUE = 250;
	private static final int OPEN_DULATION_DEFALUT_VALUE = 250;
	private static final double FOCUS_ALPHA_DEFAULT_VALUE = 0.4;

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(COLOR_FIELD, CATEGORY_PROPERTY, "color");
		addStringModelProperty(LABEL_FIELD, CATEGORY_PROPERTY, "label");
		addColorModelProperty(SELECTED_COLOR, CATEGORY_PROPERTY, ColorUtil.toRGB("#000000"));
		addIntModelProperty(SELECTED_INDEX, CATEGORY_PROPERTY, 0);
		addBooleanModelProperty(SHOW_TEXT_FIELD, CATEGORY_PROPERTY, true);

		//Style
		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#A5A9AE"));
		addNumberModelProperty(CLOSE_DURATION, CATEGORY_STYLE, CLOSE_DULATION_DEFALUT_VALUE);
		addStringModelProperty(CLOSE_EASING_FUNCTION, CATEGORY_STYLE);
		addColorModelProperty(COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#0B333C"));
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3"));
		addColorModelProperty(DISABLED_ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#999999"));
		addStringModelProperty(FILL_ALPHAS, CATEGORY_STYLE, "[0.6,0.4]");
		addStringModelProperty(FILL_COLORS, CATEGORY_STYLE, "[0xFFFFFF, 0xCCCCCC]");
		addDoubleModelProperty(FOCUS_ALPHA, CATEGORY_STYLE, FOCUS_ALPHA_DEFAULT_VALUE);
		addStringModelProperty(FOCUS_ROUNDED_CORNERS, CATEGORY_STYLE, "tl tr bl br");
		addListModelProperty(FONT_ANTI_ALIAS_TYPE, CATEGORY_STYLE, LIST_FONT_ALIAS_TYPE);
		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana");
		addListModelProperty(FONT_GRID_FIT_TYPE, CATEGORY_STYLE, LIST_GRID_FIT_TYPE);
		addNumberModelProperty(FONT_SHARPNESS, CATEGORY_STYLE, 0);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 11);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, LIST_FONT_STYLE);
		addNumberModelProperty(FONT_THICKNESS, CATEGORY_STYLE, 0);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT);
		addStringModelProperty(HIGHLIGHT_ALPHAS, CATEGORY_STYLE, "[0.3,0.0]");
		addColorModelProperty(ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#111111"));
		addBooleanModelProperty(KERNING, CATEGORY_STYLE, false);
		addNumberModelProperty(LEADING, CATEGORY_STYLE, 2);
		addNumberModelProperty(LETTER_SPACING, CATEGORY_STYLE, 0);
		addNumberModelProperty(OPEN_DURATION, CATEGORY_STYLE, OPEN_DULATION_DEFALUT_VALUE);
		addStringModelProperty(OPEN_EASING_FUNCTION, CATEGORY_STYLE);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 5);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 5);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 5);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 4);
		addColorModelProperty(SWATCH_BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#000000"));
		addNumberModelProperty(SWATCH_BORDER_SIZE, CATEGORY_STYLE, 1);
		addStringModelProperty(SWATCH_PANEL_STYLE_NAME, CATEGORY_STYLE);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER);
		addListModelProperty(TEXT_DECORATION, CATEGORY_STYLE, LIST_TEXT_DECORATION);
		addNumberModelProperty(TEXT_INDENT, CATEGORY_STYLE, 0);

		//Event
		addStringModelProperty(CHANGE, CATEGORY_EVENT);
		addStringModelProperty(CLOSE, CATEGORY_EVENT);
		addStringModelProperty(ENTER, CATEGORY_EVENT);
		addStringModelProperty(ENTER, CATEGORY_EVENT);
		addStringModelProperty(ITEM_ROLL_OVER, CATEGORY_EVENT);
		addStringModelProperty(ITEM_ROLL_OUT, CATEGORY_EVENT);
		addStringModelProperty(OPEN, CATEGORY_EVENT);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

}
