package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * model of mx.controls.ComboBox
 * 
 * @author ogawahideko
 * 
 */
public class ComboBoxModel extends AbstractComboBase {
	private static final int SELECTION_DURATION_DEFAULT_VALUE = 250;

	private static final int OPEN_DURATION_DEFAULT_VALUE = 250;

	private static final double FOCUS_ALPHA_DEFAULT_VALUE = 0.4;

	private static final int CLOSE_DURATION_DEFAULT_VALUE = 250;

	private static final int ARROW_BUTTON_WIDTHDEFAULT_VALUE = 22;

	public static final String COMPONENT_NAME = "ComboBox";

	//properties
	public static final String DATA_PROVIDER = "dataProvider";
	public static final String DROPDOWN_FACTORY = "dropdownFactory";
	public static final String DROPDOWN_WIDTH = "dropdownWidth";
	public static final String ITEM_RENDERER = "itemRenderer";
	public static final String LABEL_FIELD = "labelField";
	public static final String LABEL_FUNCTION = "labelFunction";
	public static final String PROMPT = "prompt";
	public static final String ROW_COUNT = "rowCount";

	//styles
	public static final String ALTERNATING_ITEM_COLORS = "alternatingItemColors";
	public static final String ARROW_BUTTON_WIDTH = "arrowButtonWidth";
	public static final String BORDER_COLOR = "borderColor";
	public static final String BORDER_THICKNESS = "borderThickness";
	public static final String CLOSE_DURATION = "closeDuration";
	public static final String CLOSE_EASING_FUNCTION = "closeEasingFunction";
	public static final String COLOR = "color";
	public static final String CORNER_RADIUS = "cornerRadius";
	public static final String DISABLED_COLOR = "disabledColor";
	public static final String DISABLED_ICON_COLOR = "disabledIconColor";
	public static final String DROPDOWN_BORDER_COLOR = "dropdownBorderColor";
	public static final String DROPDOWN_STYLE_NAME = "dropdownStyleName";
	public static final String FILL_ALPAHS = "fillAlphas";
	public static final String FILL_COLORS = "fillColors";
	public static final String FOCUS_ALPHA = "focusAlpha";
	public static final String FOCUS_ROUNDED_CORNERS = "focusRoundedCorners";
	public static final String FONT_ANTI_ALIAS_TYPE = "fontAntiAliasType";
	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_GRID_FIT_TYPE = "fontGridFitType";
	public static final String FONT_SHAPNESS = "fontSharpness";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_THICKNESS = "fontThickness";
	public static final String FONT_WEIGHT = "fontWeight";
	public static final String HIGHLIGHT_ALPHAS = "highlightAlphas";
	public static final String ICON_COLOR = "iconColor";
	public static final String LEADING = "leading";
	public static final String OPEN_DURATION = "openDuration";
	public static final String OPEN_EASING_FUNCTION = "openEasingFunction";
	public static final String PADDING_TOP = "paddingTop";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String ROLL_OVER_COLOR = "rollOverColor";
	public static final String SELECTION_COLOR = "selectionColor";
	public static final String SELECTION_DURATION = "selectionDuration";
	public static final String SELECTION_EASING_FUNCTION = "selectionEasingFunction";
	public static final String TEXT_ALIGN = "textAlign";
	public static final String TEXT_DECORATION = "textDecoration";
	public static final String TEXT_INDENT = "textIndent";
	public static final String TEXT_ROLL_OVER_COLOR = "textRollOverColor";
	public static final String TEXT_SELECTED_COLOR = "textSelectedColor";

	// events
	public static final String CHANGE = "change";
	public static final String CLOSE = "close";
	public static final String DATA_CHANGE = "dataChange";
	public static final String ENTER = "enter";
	public static final String ITEM_ROLL_OVER = "itemRollOver";
	public static final String ITEM_ROLL_OUT = "itemRollOut";
	public static final String OPEN = "open";
	public static final String SCROLL = "scroll";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(DATA_PROVIDER, CATEGORY_PROPERTY);
		addStringModelProperty(DROPDOWN_FACTORY, CATEGORY_PROPERTY);
		addNumberModelProperty(DROPDOWN_WIDTH, CATEGORY_PROPERTY);
		addStringModelProperty(ITEM_RENDERER, CATEGORY_PROPERTY);
		addStringModelProperty(LABEL_FIELD, CATEGORY_PROPERTY);
		addStringModelProperty(LABEL_FUNCTION, CATEGORY_PROPERTY);
		addStringModelProperty(PROMPT, CATEGORY_PROPERTY);
		addNumberModelProperty(ROW_COUNT, CATEGORY_PROPERTY, 5);

		addStringModelProperty(ALTERNATING_ITEM_COLORS, CATEGORY_STYLE);
		addNumberModelProperty(ARROW_BUTTON_WIDTH, CATEGORY_STYLE, ARROW_BUTTON_WIDTHDEFAULT_VALUE);
		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#B7BAABC"));
		addNumberModelProperty(BORDER_THICKNESS, CATEGORY_STYLE, 1);
		addNumberModelProperty(CLOSE_DURATION, CATEGORY_STYLE, CLOSE_DURATION_DEFAULT_VALUE);
		addStringModelProperty(CLOSE_EASING_FUNCTION, CATEGORY_STYLE);
		addColorModelProperty(COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#0B333C"));
		addNumberModelProperty(CORNER_RADIUS, CATEGORY_STYLE, 0);
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3"));
		addColorModelProperty(DISABLED_ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#919999"));
		addColorModelProperty(DROPDOWN_BORDER_COLOR, CATEGORY_STYLE);
		addStringModelProperty(DROPDOWN_STYLE_NAME, CATEGORY_STYLE);
		addStringModelProperty(FILL_ALPAHS, CATEGORY_STYLE, "[0.6, 0.4]");
		addStringModelProperty(FILL_COLORS, CATEGORY_STYLE, "[0xFFFFFF, 0xCCCCCC]");
		addDoubleModelProperty(FOCUS_ALPHA, CATEGORY_STYLE, FOCUS_ALPHA_DEFAULT_VALUE);
		addStringModelProperty(FOCUS_ROUNDED_CORNERS, CATEGORY_STYLE);
		addListModelProperty(FONT_ANTI_ALIAS_TYPE, CATEGORY_STYLE, LIST_FONT_ALIAS_TYPE);
		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana");
		addListModelProperty(FONT_GRID_FIT_TYPE, CATEGORY_STYLE, LIST_GRID_FIT_TYPE);
		addNumberModelProperty(FONT_SHAPNESS, CATEGORY_STYLE, 0);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 10);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, LIST_FONT_STYLE);
		addNumberModelProperty(FONT_THICKNESS, CATEGORY_STYLE, 0);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT);
		addStringModelProperty(HIGHLIGHT_ALPHAS, CATEGORY_STYLE, "[0.3,0.0]");
		addColorModelProperty(ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#111111"));
		addNumberModelProperty(LEADING, CATEGORY_STYLE, 0);
		addNumberModelProperty(OPEN_DURATION, CATEGORY_STYLE, OPEN_DURATION_DEFAULT_VALUE);
		addStringModelProperty(OPEN_EASING_FUNCTION, CATEGORY_STYLE);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 5);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 5);
		addColorModelProperty(ROLL_OVER_COLOR, CATEGORY_STYLE);
		addColorModelProperty(SELECTION_COLOR, CATEGORY_STYLE);
		addNumberModelProperty(SELECTION_DURATION, CATEGORY_STYLE, SELECTION_DURATION_DEFAULT_VALUE);
		addStringModelProperty(SELECTION_EASING_FUNCTION, CATEGORY_STYLE);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER);
		addListModelProperty(TEXT_DECORATION, CATEGORY_STYLE, LIST_TEXT_DECORATION);
		addNumberModelProperty(TEXT_INDENT, CATEGORY_STYLE, 0);
		addColorModelProperty(TEXT_ROLL_OVER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#2B333C"));
		addColorModelProperty(TEXT_SELECTED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#2B333C"));

		addStringModelProperty(CHANGE, CATEGORY_EVENT);
		addStringModelProperty(CLOSE, CATEGORY_EVENT);
		addStringModelProperty(DATA_CHANGE, CATEGORY_EVENT);
		addStringModelProperty(ENTER, CATEGORY_EVENT);
		addStringModelProperty(ITEM_ROLL_OVER, CATEGORY_EVENT);
		addStringModelProperty(ITEM_ROLL_OUT, CATEGORY_EVENT);
		addStringModelProperty(OPEN, CATEGORY_EVENT);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

}
