package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.Tree
 * 
 * @author ogawahideko
 *
 */
public class TreeModel extends ListModel {
	private static final int OPEN_DURATION_DEFAULT_VALUE = 250;
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "Tree";

	public static final String DATA_DESCRIPTOR = "dataDescriptor";
	public static final String DATA_PROVIDER = "dataProvider";
	public static final String DRAG_MOVE_ENABLED = "dragMoveEnabled";
	public static final String FIRST_VISIBLE_ITEM = "firstVisibleItem";
	public static final String HAS_ROOT = "hasRoot";
	public static final String ITEM_ICONS = "itemIcons";
	public static final String MAX_HORIZONTAL_SCROLL_POSITION = "maxHorizontalScrollPosition";
	public static final String OPEN_ITEMS = "openItems";
	public static final String SHOW_ROOT = "showRoot";

	public static final String ALTERNATING_ITEM_COLORS = "alternatingItemColors";
	public static final String BACKGROUND_DISABLED_COLOR = "backgroundDisabledColor";
	public static final String DEFAULT_LEAF_ICON = "defaultLeafIcon";
	public static final String DEPTH_COLORS = "depthColors";
	public static final String DISCLOSURE_CLOSED_ICON = "disclosureClosedIcon";
	public static final String DISCLOSURE_OPEN_ICON = "disclosureOpenIcon";
	public static final String FOLDER_CLOSED_ICON = "folderClosedIcon";
	public static final String FOLDER_OPEN_ICON = "folderOpenIcon";
	public static final String INDENTATION = "indentation";
	public static final String OPEN_DURATION = "openDuration";
	public static final String OPEN_EASING_FUNCTION = "openEasingFunction";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String ROLL_OVER_COLOR = "rollOverColor";
	public static final String SELECTION_COLOR = "selectionColor";
	public static final String SELECTION_DISABLED_COLOR = "selectionDisabledColor";
	public static final String SELECTION_EASING_FUNCTION = "selectionEasingFunction";
	public static final String TEXT_ROLL_OVER_COLOR = "textRollOverColor";
	public static final String TEXT_SELECTED_COLOR = "textSelectedColor";

	public static final String CHANGE = "change";
	public static final String ITEM_CLOSE = "itemClose";
	public static final String ITEM_OPEN = "itemOpen";
	public static final String ITEM_OPENING = "itemOpening";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(DATA_DESCRIPTOR, CATEGORY_PROPERTY);
		addStringModelProperty(DATA_PROVIDER, CATEGORY_PROPERTY);
		addBooleanModelProperty(DRAG_MOVE_ENABLED, CATEGORY_PROPERTY, true);
		addStringModelProperty(FIRST_VISIBLE_ITEM, CATEGORY_PROPERTY);
		addBooleanModelProperty(HAS_ROOT, CATEGORY_PROPERTY, false);
		addStringModelProperty(ITEM_ICONS, CATEGORY_PROPERTY);
		addNumberModelProperty(MAX_HORIZONTAL_SCROLL_POSITION, CATEGORY_PROPERTY, 0);
		addStringModelProperty(OPEN_ITEMS, CATEGORY_PROPERTY);
		addBooleanModelProperty(SHOW_ROOT, CATEGORY_PROPERTY, true);

		//Styles
		addStringModelProperty(ALTERNATING_ITEM_COLORS, CATEGORY_STYLE);
		addColorModelProperty(BACKGROUND_DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#DDDDDD"));
		addImageModelProperty(DEFAULT_LEAF_ICON, CATEGORY_STYLE);
		addStringModelProperty(DEPTH_COLORS, CATEGORY_STYLE);
		addImageModelProperty(DISCLOSURE_CLOSED_ICON, CATEGORY_STYLE);
		addImageModelProperty(DISCLOSURE_OPEN_ICON, CATEGORY_STYLE);
		addImageModelProperty(FOLDER_CLOSED_ICON, CATEGORY_STYLE);
		addImageModelProperty(FOLDER_OPEN_ICON, CATEGORY_STYLE);
		addNumberModelProperty(INDENTATION, CATEGORY_STYLE, 17);
		addNumberModelProperty(OPEN_DURATION, CATEGORY_STYLE, OPEN_DURATION_DEFAULT_VALUE);
		addStringModelProperty(OPEN_EASING_FUNCTION, CATEGORY_STYLE);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 2);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0);
		addColorModelProperty(ROLL_OVER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AADEFF"));
		addColorModelProperty(SELECTION_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#7FCDFE"));
		addColorModelProperty(SELECTION_DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#DDDDDD"));
		addStringModelProperty(SELECTION_EASING_FUNCTION, CATEGORY_STYLE);
		addColorModelProperty(TEXT_ROLL_OVER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#2B333C"));
		addColorModelProperty(TEXT_SELECTED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#2B333C"));

		addStringModelProperty(CHANGE, CATEGORY_EVENT);
		addStringModelProperty(ITEM_CLOSE, CATEGORY_EVENT);
		addStringModelProperty(ITEM_OPEN, CATEGORY_EVENT);
		addStringModelProperty(ITEM_OPENING, CATEGORY_EVENT);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}
}
