package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.core.WindowedApplication.
 * 
 * @author ogawahideko
 *
 */
public class WindowedApplicationModel extends ApplicationModel {
	private static final int MIN_WIDTH_DEFAULT_VALUE = 100;
	private static final int MIN_HEIGHT_DEFAULT_VALUE = 100;
	private static final int MAX_WIDTH_DEFAULT_VALUE = 10000;
	private static final int MAX_HEIGHT_DEFAULT_VALUE = 10000;
	private static final String COMPONENT_NAME = "WindowedApplication";

	//properties
	public static final String ALWAYS_IN_FRONT = "alwaysInFront";
	public static final String AUTO_EXIT = "autoExit";
	public static final String DOCK_ICON_MENU = "dockIconMenu";
	public static final String MAX_HEIGHT = "maxHeight";
	public static final String MAX_WIDTH = "maxWidth";
	public static final String MENU = "menu";
	public static final String MIN_HEIGHT = "minHeight";
	public static final String MIN_WIDTH = "minWidth";
	public static final String SHOW_GRIPPER = "showGripper";
	public static final String SHOW_STATUS_BAR = "showStatusBar";
	public static final String SHOW_TITLE_BAR = "showTitleBar";
	public static final String STATUS = "status";
	public static final String STATUS_BAR_FACTORY = "statusBarFactory";
	public static final String SYSTEM_TRAY_ICON_MENU = "systemTrayIconMenu";
	public static final String TITLE = "title";
	public static final String TITLE_BAR_FACTORY = "titleBarFactory";
	public static final String TITLE_ICON = "titleIcon";

	//styles
	public static final String BUTTON_ALIGNMENT = "buttonAlignment";
	public static final String BUTTON_PADDING = "buttonPadding";
	public static final String CLOSE_BUTTON_SKIN = "closeButtonSkin";
	public static final String GRIPPER_PADDING = "gripperPadding";
	public static final String GRIPPER_STYLE_NAME = "gripperStyleName";
	public static final String HEADER_HEIGHT = "headerHeight";
	public static final String MAXIMIZE_BUTTON_SKIN = "maximizeButtonSkin";
	public static final String MINIMIZE_BUTTON_SKIN = "minimizeButtonSkin";
	public static final String RESTORE_BUTTON_SKIN = "restoreButtonSkin";
	public static final String SHOW_FLEX_CHROME = "showFlexChrome";
	public static final String STATUS_BAR_BACKGROUND_COLOR = "statusBarBackgroundColor";
	public static final String STATUS_BAR_BACKGROUND_SKIN = "statusBarBackgroundSkin";
	public static final String STATUS_TEXT_STYLE_NAME = "statusTextStyleName";
	public static final String TITLE_ALIGNMENT = "titleAlignment";
	public static final String TITLE_BAR_BACKGROUND_SKIN = "titleBarBackgroundSkin";
	public static final String TITLE_BAR_BUTTON_PADDING = "titleBarButtonPadding";
	public static final String TITLE_BAR_CLOLORS = "titleBarColors";
	public static final String TITLE_TEXT_STYLE_NAME = "titleTextStyleName";

	//Effects
	public static final String CLOSE_EFECT = "closeEffect";
	public static final String MINIMIZE_EFFECT = "minimizeEffect";
	public static final String UNMINIMIZE_EFFECT = "unminimizeEffect";

	//Events
	public static final String APPLICATION_ACTIVATE = "applicationActivate";
	public static final String APPLICATION_DEACTIVATE = "applicationDeactivate";
	public static final String CLOSING = "closing";
	public static final String DISPLAY_STAGE_CHANGE = "displayStateChange";
	public static final String DISPLAY_STAGE_CHANGING = "displayStateChanging";
	public static final String INVOLE = "invoke";
	public static final String MOVING = "moving";
	public static final String NETWORK_CHANGE = "networkChange";
	public static final String RESIZING = "resizing";
	public static final String WINDOW_COMPLETE = "windowComplete";
	public static final String WINDOW_MOVE = "windowMove";
	public static final String WINDOW_RESIZE = "windowResize";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();

		//Properties
		addBooleanModelProperty(ALWAYS_IN_FRONT, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(AUTO_EXIT, CATEGORY_PROPERTY, true);
		addStringModelProperty(DOCK_ICON_MENU, CATEGORY_PROPERTY);
		addNumberModelProperty(MAX_HEIGHT, CATEGORY_PROPERTY, MAX_HEIGHT_DEFAULT_VALUE);
		addNumberModelProperty(MAX_WIDTH, CATEGORY_PROPERTY, MAX_WIDTH_DEFAULT_VALUE);
		addStringModelProperty(MENU, CATEGORY_PROPERTY);
		addNumberModelProperty(MIN_HEIGHT, CATEGORY_PROPERTY, MIN_HEIGHT_DEFAULT_VALUE);
		addNumberModelProperty(MIN_WIDTH, CATEGORY_PROPERTY, MIN_WIDTH_DEFAULT_VALUE);
		addBooleanModelProperty(SHOW_GRIPPER, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SHOW_STATUS_BAR, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SHOW_TITLE_BAR, CATEGORY_PROPERTY, true);
		addStringModelProperty(STATUS, CATEGORY_PROPERTY);
		addStringModelProperty(STATUS_BAR_FACTORY, CATEGORY_PROPERTY);
		addStringModelProperty(SYSTEM_TRAY_ICON_MENU, CATEGORY_PROPERTY);
		addStringModelProperty(TITLE, CATEGORY_PROPERTY);
		addStringModelProperty(TITLE_BAR_FACTORY, CATEGORY_PROPERTY);
		addImageModelProperty(TITLE_ICON, CATEGORY_PROPERTY);

		//Styles
		addListModelProperty(BUTTON_ALIGNMENT, CATEGORY_STYLE, LIST_BUTTON_ALIGNMENT, "auto");
		addNumberModelProperty(BUTTON_PADDING, CATEGORY_STYLE, 2);
		addStringModelProperty(CLOSE_BUTTON_SKIN, CATEGORY_STYLE);
		addNumberModelProperty(GRIPPER_PADDING, CATEGORY_STYLE, 3);
		addStringModelProperty(GRIPPER_STYLE_NAME, CATEGORY_STYLE);
		addNumberModelProperty(HEADER_HEIGHT, CATEGORY_STYLE);
		addStringModelProperty(MAXIMIZE_BUTTON_SKIN, CATEGORY_STYLE);
		addStringModelProperty(MINIMIZE_BUTTON_SKIN, CATEGORY_STYLE);
		addStringModelProperty(RESTORE_BUTTON_SKIN, CATEGORY_STYLE);
		addBooleanModelProperty(SHOW_FLEX_CHROME, CATEGORY_STYLE, true);
		addColorModelProperty(STATUS_BAR_BACKGROUND_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#C0C0C0"));
		addStringModelProperty(STATUS_BAR_BACKGROUND_SKIN, CATEGORY_STYLE);
		addStringModelProperty(STATUS_TEXT_STYLE_NAME, CATEGORY_STYLE);
		addListModelProperty(TITLE_ALIGNMENT, CATEGORY_STYLE, LIST_TITLE_ALIGNMENT, "auto");
		addStringModelProperty(TITLE_BAR_BACKGROUND_SKIN, CATEGORY_STYLE);
		addNumberModelProperty(TITLE_BAR_BUTTON_PADDING, CATEGORY_STYLE, 5);
		addStringModelProperty(TITLE_BAR_CLOLORS, CATEGORY_STYLE);
		addStringModelProperty(TITLE_TEXT_STYLE_NAME, CATEGORY_STYLE);

		addStringModelProperty(CLOSE_EFECT, CATEGORY_EFFECT);
		addStringModelProperty(MINIMIZE_EFFECT, CATEGORY_EFFECT);
		addStringModelProperty(UNMINIMIZE_EFFECT, CATEGORY_EFFECT);

		addStringModelProperty(APPLICATION_ACTIVATE, CATEGORY_EVENT);
		addStringModelProperty(APPLICATION_DEACTIVATE, CATEGORY_EVENT);
		addStringModelProperty(CLOSING, CATEGORY_EVENT);
		addStringModelProperty(DISPLAY_STAGE_CHANGE, CATEGORY_EVENT);
		addStringModelProperty(DISPLAY_STAGE_CHANGING, CATEGORY_EVENT);
		addStringModelProperty(INVOLE, CATEGORY_EVENT);
		addStringModelProperty(MOVING, CATEGORY_EVENT);
		addStringModelProperty(NETWORK_CHANGE, CATEGORY_EVENT);
		addStringModelProperty(RESIZING, CATEGORY_EVENT);
		addStringModelProperty(WINDOW_COMPLETE, CATEGORY_EVENT);
		addStringModelProperty(WINDOW_MOVE, CATEGORY_EVENT);
		addStringModelProperty(WINDOW_RESIZE, CATEGORY_EVENT);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

}
