package net.sf.amateras.air.natures;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

import net.sf.amateras.air.AIRPlugin;

public class ReadStreamThread extends Thread {

	private static final int BUFFER_SIZE = 1024 * 8;
	private InputStream in;
	private PrintStream out;
	private boolean finished;

	public ReadStreamThread(InputStream in, PrintStream out) {
		this.in = in;
		this.out = out;
	}

	@Override
	public void run() {
		try {
			byte[] buf = new byte[BUFFER_SIZE];
			int length = 0;
			while ((length = in.read(buf)) > 0) {
				out.print(new String(buf, 0, length));
			}
		} catch (IOException ex) {
			AIRPlugin.logException(ex);
		} finally {
			try {
				in.close();
			} catch (IOException ex) {
				AIRPlugin.logException(ex);
			}
		}
		finished = true;
	}

	public boolean isFinished() {
		return this.finished;
	}
}
