package net.sf.amateras.air.preferences;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.SDKSourcesUtil;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * The property page for the AS3 Parse.
 * 
 * @author ogawahideko
 */

public class AS3SettingPage extends PreferencePage implements IWorkbenchPreferencePage {
	private Button btnEnabled;
	private TableViewer tblSDKSources;
	private Button btnOutline;
	private Button btnContentAssistMXML;
	private Button btnContentAssistAS3;
	private Button btnContentAssistFLEX;

	public AS3SettingPage() {
		super(AIRPlugin.getResourceString("AS3SETTING"));
		setPreferenceStore(AIRPlugin.getDefault().getPreferenceStore());
		setDescription(AIRPlugin.getResourceString("AS3PARSE_DESCRIPTION"));
	}

	public void init(IWorkbench workbench) {

	}

	@Override
	protected Control createContents(Composite parent) {

		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		Composite enableComposite = new Composite(composite, SWT.NULL);
		enableComposite.setLayout(new GridLayout(1, false));
		enableComposite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		btnEnabled = new Button(enableComposite, SWT.CHECK);
		btnEnabled.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		btnEnabled.setText(AIRPlugin.getResourceString("AS3PARSE_IS_ENABLE"));
		btnEnabled.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				updateButton();
			}
		});
		btnEnabled.setSelection(getPreferenceStore().getBoolean(AIRPlugin.PREF_AS3_IS_PARSE_ENABLED));

		Group parse = new Group(enableComposite, SWT.NULL);
		parse.setLayout(new GridLayout(1, false));
		parse.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		btnOutline = new Button(parse, SWT.CHECK);
		btnOutline.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		btnOutline.setText(AIRPlugin.getResourceString("AS3PARSE_IS_SHOW_OUTLINE"));
		btnOutline.setSelection(getPreferenceStore().getBoolean(AIRPlugin.PREF_AS3_IS_SHOW_OUTLINE_ENABLED));
		btnContentAssistMXML = new Button(parse, SWT.CHECK);
		btnContentAssistMXML.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		btnContentAssistMXML.setText(AIRPlugin.getResourceString("AS3PARSE_IS_CONTENT_ASSIST_MXML"));
		btnContentAssistMXML.setSelection(getPreferenceStore().getBoolean(
				AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_MXML_ENABLED));
		btnContentAssistAS3 = new Button(parse, SWT.CHECK);
		btnContentAssistAS3.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		btnContentAssistAS3.setText(AIRPlugin.getResourceString("AS3PARSE_IS_CONTENT_ASSIST_AS3"));
		btnContentAssistAS3.setSelection(getPreferenceStore().getBoolean(
				AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_AS3_ENABLED));
		btnContentAssistFLEX = new Button(parse, SWT.CHECK);
		btnContentAssistFLEX.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		btnContentAssistFLEX.setText(AIRPlugin.getResourceString("AS3PARSE_IS_CONTENT_ASSIST_FLEX_CLASS"));
		btnContentAssistFLEX.setSelection(getPreferenceStore().getBoolean(
				AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_FLEX_ENABLED));

		Group setting = new Group(composite, SWT.NULL);
		setting.setLayout(new GridLayout(1, false));
		setting.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		setting.setText(AIRPlugin.getResourceString("SDK_SOURCES"));

		tblSDKSources = new TableViewer(setting);
		tblSDKSources.getControl().setLayoutData(new GridData(GridData.FILL_BOTH));
		tblSDKSources.setContentProvider(new ArrayContentProvider());

		try {
			tblSDKSources.setInput(SDKSourcesUtil.getSDKSources());
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		updateButton();
		return composite;
	}

	private void updateButton() {
		boolean isEnabled = btnEnabled.getSelection();
		btnOutline.setEnabled(isEnabled);
		btnContentAssistMXML.setEnabled(isEnabled);
		btnContentAssistAS3.setEnabled(isEnabled);
		btnContentAssistFLEX.setEnabled(isEnabled);
	}

	@Override
	public boolean performOk() {
		IPreferenceStore store = getPreferenceStore();
		boolean isEnabled = btnEnabled.getSelection();
		store.setValue(AIRPlugin.PREF_AS3_IS_PARSE_ENABLED, isEnabled);
		if (isEnabled) {
			store.setValue(AIRPlugin.PREF_AS3_IS_SHOW_OUTLINE_ENABLED, btnOutline.getSelection());
			store.setValue(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_MXML_ENABLED, btnContentAssistMXML.getSelection());
			store.setValue(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_AS3_ENABLED, btnContentAssistAS3.getSelection());
			store.setValue(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_FLEX_ENABLED, btnContentAssistFLEX.getSelection());
		} else {
			store.setValue(AIRPlugin.PREF_AS3_IS_SHOW_OUTLINE_ENABLED, false);
			store.setValue(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_MXML_ENABLED, false);
			store.setValue(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_AS3_ENABLED, false);
			store.setValue(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_FLEX_ENABLED, false);
		}
		return super.performOk();
	}

	@Override
	protected void performDefaults() {
		IPreferenceStore store = getPreferenceStore();
		store.setValue(AIRPlugin.PREF_AS3_IS_PARSE_ENABLED, store
				.getDefaultBoolean(AIRPlugin.PREF_AS3_IS_PARSE_ENABLED));
		store.setValue(AIRPlugin.PREF_AS3_IS_SHOW_OUTLINE_ENABLED, store
				.getDefaultBoolean(AIRPlugin.PREF_AS3_IS_SHOW_OUTLINE_ENABLED));
		store.setValue(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_MXML_ENABLED, store
				.getDefaultBoolean(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_MXML_ENABLED));
		store.setValue(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_AS3_ENABLED, store
				.getDefaultBoolean(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_AS3_ENABLED));
		store.setValue(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_FLEX_ENABLED, store
				.getDefaultBoolean(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_FLEX_ENABLED));
		super.performDefaults();
	}

}
