package net.sf.amateras.air.swfview;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class SWFViewEditor extends EditorPart implements IResourceChangeListener {

	private Browser browser;

	public SWFViewEditor() {
		System.out.println("SWFView");
		ResourcesPlugin.getWorkspace().addResourceChangeListener(this);
	}

	@Override
	public void dispose() {
		ResourcesPlugin.getWorkspace().removeResourceChangeListener(this);
		super.dispose();
	}

	@Override
	public void doSave(IProgressMonitor monitor) {
	}

	@Override
	public void doSaveAs() {
	}

	@Override
	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		if (!(input instanceof IFileEditorInput)) {
			throw new PartInitException("Invalid Input: Must be IFileEditorInput");
		}
		setSite(site);
		setInput(input);
	}

	@Override
	public boolean isDirty() {
		return false;
	}

	@Override
	public boolean isSaveAsAllowed() {
		return false;
	}

	@Override
	public void createPartControl(Composite parent) {
		browser = new Browser(parent, SWT.NONE);
		IFileEditorInput input = (IFileEditorInput) getEditorInput();
		setPartName(input.getName());
		setTitleToolTip(input.getFile().toString());
		IPath fullPath = input.getFile().getFullPath();
		IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
		if (!root.isPrefixOf(fullPath)) {
			fullPath = root.append(fullPath);
		}
		browser.setUrl(fullPath.toOSString());
	}

	@Override
	public void setFocus() {

	}

	public void resourceChanged(final IResourceChangeEvent event) {
		if (event.getType() == IResourceChangeEvent.POST_CHANGE) {
			final IEditorInput input = getEditorInput();

			if (input instanceof IFileEditorInput) {
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						IFile file = ((IFileEditorInput) input).getFile();
						if (!file.exists()) {
							IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
							page.closeEditor(SWFViewEditor.this, false);
						} else {
							IPath path = ((IFileEditorInput) input).getFile().getFullPath();
							IResourceDelta delta = event.getDelta();
							IResourceDelta member = delta.findMember(path);
							if (member != null && member.getKind() != IResourceDelta.REMOVED) {
								refresh();
							}
						}
					}
				});
			}
		}
	}

	public void refresh() {
		if (browser != null && !browser.isDisposed()) {
			browser.refresh();
		}
	}
}
