package net.sf.amateras.air.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.asclipse.as3.ParserUtil;
import jp.sourceforge.asclipse.as3.ParserUtil.AS3ParserException;
import jp.sourceforge.asclipse.as3.element.AS3Element;

public class AS3ElementsUtil {
	private static Map<String, AS3Element> elementsStore = new HashMap<String, AS3Element>();

	private AS3ElementsUtil() {
		// no instance
	}

	public static AS3Element addAS3Element(String fileName, InputStream is) {
		AS3Element as3Element = null;
		try {
			as3Element = ParserUtil.parse(is);
			elementsStore.put(fileName, as3Element);

		} catch (AS3ParserException ex) {
			// nothing todo.
		}
		return as3Element;
	}

	public static AS3Element getAS3Element(String className, InputStream is) {
		AS3Element as3Element = elementsStore.get(className);
		if (as3Element != null) {
			return as3Element;
		} else {
			return addAS3Element(className, is);
		}
	}
}
