/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.NoSuchPropertyException;
import ognl.OgnlException;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.BindVariable;
import org.seasar.fisshplate.core.element.AbstractCell;
import org.seasar.fisshplate.core.element.TemplateElement;
import org.seasar.fisshplate.exception.FPMergeException;
import org.seasar.fisshplate.util.OgnlUtil;

public class El
implements TemplateElement {
    private Map expressionMap = new HashMap();
    protected AbstractCell targetElement;
    private String originalCellValue;

    public El(AbstractCell target) {
        this.targetElement = target;
        this.originalCellValue = (String)target.getCellValue();
        Pattern patEl = Pattern.compile("\\$\\{[^\\$\\{\\}]+\\}");
        Matcher mat = patEl.matcher(this.originalCellValue);
        while (mat.find()) {
            this.expressionMap.put(mat.group(), null);
        }
    }

    public void merge(FPContext context) throws FPMergeException {
        Object value = this.getBoundValue(context);
        this.targetElement.setCellValue(value);
        this.targetElement.merge(context);
    }

    protected Object getBoundValue(FPContext context) throws FPMergeException {
        Object value = null;
        if (context.isSkipMerge()) {
            value = "";
        } else {
            this.putValueToMap(context);
            value = this.buildValue();
        }
        return value;
    }

    private void putValueToMap(FPContext context) throws FPMergeException {
        Map data = context.getData();
        Set key = this.expressionMap.keySet();
        Iterator itr = key.iterator();
        while (itr.hasNext()) {
            String expString = (String)itr.next();
            BindVariable bindVar = new BindVariable(expString);
            Object value = this.getValue(data, bindVar);
            value = this.convertLineFeed(value);
            this.expressionMap.put(expString, value);
        }
    }

    protected Object convertLineFeed(Object value) {
        if (value instanceof String) {
            value = ((String)value).replaceAll("(\r\n|\r)", "\n");
        }
        return value;
    }

    private Object buildValue() {
        if (this.onlySingleBindVarIn(this.originalCellValue)) {
            Set keySet = this.expressionMap.keySet();
            return this.expressionMap.get(keySet.iterator().next());
        }
        return this.replaceAllBindVariable(this.originalCellValue);
    }

    private String replaceAllBindVariable(String cellValue) {
        Set keySet = this.expressionMap.keySet();
        Iterator itr = keySet.iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            cellValue = cellValue.replaceAll(Pattern.quote(key), this.expressionMap.get(key).toString());
        }
        return cellValue;
    }

    private boolean onlySingleBindVarIn(String value) {
        if (this.expressionMap.size() != 1) {
            return false;
        }
        String exp = this.expressionMap.keySet().iterator().next().toString();
        return (value = value.replaceAll(Pattern.quote(exp), "")).trim().length() == 0;
    }

    private Object getValue(Map data, BindVariable bindVar) throws FPMergeException {
        Object value = null;
        try {
            value = OgnlUtil.getValue(bindVar.getName(), data);
        }
        catch (RuntimeException e) {
            this.handleGetValueRuntimeException(e);
        }
        return value == null ? this.getNullValue(bindVar) : value;
    }

    private void handleGetValueRuntimeException(RuntimeException e) {
        if (e.getCause() instanceof NoSuchPropertyException) {
            return;
        }
        if (e.getCause() instanceof OgnlException) {
            return;
        }
        throw e;
    }

    private Object getNullValue(BindVariable bindVar) throws FPMergeException {
        if (bindVar.isNullAllowed()) {
            return bindVar.getNullValue();
        }
        throw new FPMergeException("EFP00004", new Object[]{bindVar.getName()}, this.targetElement.cell.getRow());
    }

    public String getOriginalCellValue() {
        return this.originalCellValue;
    }
}

