/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.element;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFHyperlink;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.core.element.AbstractCell;
import org.seasar.fisshplate.enums.LinkElementType;
import org.seasar.fisshplate.exception.FPMergeException;
import org.seasar.fisshplate.wrapper.CellWrapper;

public class Link
extends AbstractCell {
    private static Pattern pat = Pattern.compile("^\\s*\\#link-(\\S+)\\s+link\\s*=\\s*(.+)\\s+text\\s*=\\s*(.+)$");

    public Link(CellWrapper cell) {
        super(cell);
    }

    void mergeImpl(FPContext context, HSSFCell out) throws FPMergeException {
        String cellValue = this.getCellValue().toString();
        Matcher mat = pat.matcher(cellValue);
        if (!mat.find()) {
            throw new FPMergeException("EFP00013", new Object[]{cellValue}, this.cell.getRow());
        }
        String type = mat.group(1);
        String link = mat.group(2);
        String text = mat.group(3);
        LinkElementType linkType = LinkElementType.get(type);
        HSSFHyperlink hyperLink = linkType.createHyperLink();
        hyperLink.setAddress(link);
        out.setHyperlink(hyperLink);
        out.setCellValue(new HSSFRichTextString(text));
    }
}

