/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.stepcounter;

import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import tk.eclipse.plugin.stepcounter.CategoryDto;
import tk.eclipse.plugin.stepcounter.StepCounterPlugin;
import tk.stepcounter.CountResult;
import tk.stepcounter.StepCounter;
import tk.stepcounter.StepCounterFactory;
import tk.stepcounter.Util;
import tk.stepcounter.format.ExcelFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepCountView
extends ViewPart {
    private TabFolder tabFolder;
    private Table fileTable;
    private Table categoryTable;
    private Menu filePopup;
    private Menu categoryPopup;
    private MenuItem copy1;
    private MenuItem copy2;
    private MenuItem saveExcel1;
    private MenuItem saveExcel2;
    private MenuItem selectAll1;
    private MenuItem selectAll2;
    private MenuItem clear1;
    private MenuItem clear2;
    private MenuItem open;
    private Clipboard clipboard;
    private static String file = StepCounterPlugin.getResourceString("StepCountView.columnName");
    private static String type = StepCounterPlugin.getResourceString("StepCountView.columnType");
    private static String category = StepCounterPlugin.getResourceString("StepCountView.columnCategory");
    private static String step = StepCounterPlugin.getResourceString("StepCountView.columnStep");
    private static String none = StepCounterPlugin.getResourceString("StepCountView.columnNone");
    private static String comment = StepCounterPlugin.getResourceString("StepCountView.columnComment");
    private static String total = StepCounterPlugin.getResourceString("StepCountView.columnTotal");
    private HashMap<String, IFile> files = new HashMap();
    private List<CountResult> results = new ArrayList<CountResult>();

    public void createPartControl(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        TabItem tabItem1 = new TabItem(this.tabFolder, 0);
        tabItem1.setText(StepCounterPlugin.getResourceString("StepCountView.tabFile"));
        Composite composite1 = new Composite((Composite)this.tabFolder, 0);
        composite1.setLayout((Layout)new FillLayout());
        tabItem1.setControl((Control)composite1);
        this.fileTable = new Table(composite1, 65538);
        this.fileTable.setHeaderVisible(true);
        this.fileTable.setLinesVisible(true);
        String[] cols1 = new String[]{file, type, category, step, none, comment, total};
        int i = 0;
        while (i < cols1.length) {
            TableColumn col = null;
            col = i == 0 || i == 1 || i == 2 ? new TableColumn(this.fileTable, 16384) : new TableColumn(this.fileTable, 131072);
            col.setText(cols1[i]);
            if (i == 0) {
                col.setWidth(250);
            } else {
                col.setWidth(80);
            }
            col.addSelectionListener((SelectionListener)new TableHeaderListener1());
            ++i;
        }
        TabItem tabItem2 = new TabItem(this.tabFolder, 0);
        tabItem2.setText(StepCounterPlugin.getResourceString("StepCountView.tabCategory"));
        Composite composite2 = new Composite((Composite)this.tabFolder, 0);
        composite2.setLayout((Layout)new FillLayout());
        tabItem2.setControl((Control)composite2);
        this.categoryTable = new Table(composite2, 65538);
        this.categoryTable.setHeaderVisible(true);
        this.categoryTable.setLinesVisible(true);
        String[] cols2 = new String[]{category, step, none, comment, total};
        int i2 = 0;
        while (i2 < cols2.length) {
            TableColumn col = null;
            col = i2 == 0 ? new TableColumn(this.categoryTable, 16384) : new TableColumn(this.categoryTable, 131072);
            col.setText(cols2[i2]);
            if (i2 == 0) {
                col.setWidth(250);
            } else {
                col.setWidth(80);
            }
            col.addSelectionListener((SelectionListener)new TableHeaderListener2());
            ++i2;
        }
        this.clipboard = new Clipboard(parent.getDisplay());
        this.filePopup = new Menu((Decorations)this.fileTable.getShell(), 8);
        this.open = new MenuItem(this.filePopup, 8);
        this.open.setText(StepCounterPlugin.getResourceString("StepCountView.menuOpen"));
        this.open.addSelectionListener((SelectionListener)new TableOpenListener());
        this.copy1 = new MenuItem(this.filePopup, 8);
        this.copy1.setText(StepCounterPlugin.getResourceString("StepCountView.menuCopy"));
        this.copy1.addSelectionListener((SelectionListener)new TableCopyListener(this.fileTable));
        this.saveExcel1 = new MenuItem(this.filePopup, 8);
        this.saveExcel1.setText(StepCounterPlugin.getResourceString("StepCountView.menuExcel"));
        this.saveExcel1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StepCountView.this.saveToExcel();
            }
        });
        this.selectAll1 = new MenuItem(this.filePopup, 8);
        this.selectAll1.setText(StepCounterPlugin.getResourceString("StepCountView.menuSelectAll"));
        this.selectAll1.addSelectionListener((SelectionListener)new TableSelectAllListener(this.fileTable));
        new MenuItem(this.filePopup, 2);
        this.clear1 = new MenuItem(this.filePopup, 8);
        this.clear1.setText(StepCounterPlugin.getResourceString("StepCountView.menuClear"));
        this.clear1.addSelectionListener((SelectionListener)new TableClearListener());
        this.fileTable.addMouseListener((MouseListener)new TableMouseListener1());
        this.categoryPopup = new Menu((Decorations)this.categoryTable.getShell(), 8);
        this.copy2 = new MenuItem(this.categoryPopup, 8);
        this.copy2.setText(StepCounterPlugin.getResourceString("StepCountView.menuCopy"));
        this.copy2.addSelectionListener((SelectionListener)new TableCopyListener(this.categoryTable));
        this.saveExcel2 = new MenuItem(this.categoryPopup, 8);
        this.saveExcel2.setText(StepCounterPlugin.getResourceString("StepCountView.menuExcel"));
        this.saveExcel2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StepCountView.this.saveToExcel();
            }
        });
        this.selectAll2 = new MenuItem(this.categoryPopup, 8);
        this.selectAll2.setText(StepCounterPlugin.getResourceString("StepCountView.menuSelectAll"));
        this.selectAll2.addSelectionListener((SelectionListener)new TableSelectAllListener(this.categoryTable));
        new MenuItem(this.categoryPopup, 2);
        this.clear2 = new MenuItem(this.categoryPopup, 8);
        this.clear2.setText(StepCounterPlugin.getResourceString("StepCountView.menuClear"));
        this.clear2.addSelectionListener((SelectionListener)new TableClearListener());
        this.categoryTable.addMouseListener((MouseListener)new TableMouseListener2());
    }

    private void saveToExcel() {
        FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.xls"});
        String path = dialog.open();
        if (path != null) {
            ExcelFormatter formatter = new ExcelFormatter();
            byte[] data = formatter.format(this.results.toArray(new CountResult[this.results.size()]));
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(path);
                    out.write(data);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (Throwable throwable) {
                Util.close(out);
                throw throwable;
            }
            Util.close(out);
        }
    }

    public void count(ISelection selection) {
        this.fileTable.removeAll();
        this.files.clear();
        this.categoryTable.removeAll();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection iSel = (IStructuredSelection)selection;
            Iterator ite = iSel.iterator();
            long totalStep = 0L;
            long totalComment = 0L;
            long totalNone = 0L;
            ArrayList<CategoryDto> categoryResult = new ArrayList<CategoryDto>();
            while (ite.hasNext()) {
                Object obj = ite.next();
                CountResult result = null;
                if (obj instanceof ICompilationUnit) {
                    ICompilationUnit file = (ICompilationUnit)obj;
                    result = this.countFile((IFile)file.getResource(), categoryResult);
                } else if (obj instanceof IPackageFragment) {
                    IPackageFragment pkg = (IPackageFragment)obj;
                    result = this.countPackage(pkg, categoryResult);
                } else if (obj instanceof IFile) {
                    result = this.countFile((IFile)obj, categoryResult);
                } else if (obj instanceof IFolder) {
                    result = this.countFolder((IFolder)obj, categoryResult);
                }
                if (result == null) continue;
                totalStep += result.getStep();
                totalNone += result.getNon();
                totalComment += result.getComment();
            }
            String[] data = new String[]{total, "", "", String.valueOf(totalStep), String.valueOf(totalNone), String.valueOf(totalComment), String.valueOf(totalStep + totalNone + totalComment)};
            Object item = new TableItem(this.fileTable, 0);
            item.setText(data);
            totalStep = 0L;
            totalNone = 0L;
            totalComment = 0L;
            Collections.sort(categoryResult, new Comparator<CategoryDto>(){

                @Override
                public int compare(CategoryDto o1, CategoryDto o2) {
                    if (o1.getCategory().length() == 0 && o2.getCategory().length() == 0) {
                        return 0;
                    }
                    if (o1.getCategory().length() == 0) {
                        return 1;
                    }
                    if (o2.getCategory().length() == 0) {
                        return -1;
                    }
                    return o1.getCategory().compareTo(o2.getCategory());
                }
            });
            for (CategoryDto categoryDto : categoryResult) {
                String[] categoryData = new String[]{categoryDto.getCategory(), String.valueOf(categoryDto.getStep()), String.valueOf(categoryDto.getNone()), String.valueOf(categoryDto.getComment()), String.valueOf(categoryDto.getStep() + categoryDto.getNone() + categoryDto.getComment())};
                TableItem categoryItem = new TableItem(this.categoryTable, 0);
                categoryItem.setText(categoryData);
                totalStep += categoryDto.getStep();
                totalNone += categoryDto.getNone();
                totalComment += categoryDto.getComment();
            }
            data = new String[]{total, String.valueOf(totalStep), String.valueOf(totalNone), String.valueOf(totalComment), String.valueOf(totalStep + totalNone + totalComment)};
            item = new TableItem(this.categoryTable, 0);
            item.setText(data);
        }
    }

    private static CategoryDto getCategoryDto(List<CategoryDto> categoryResult, String category) {
        CategoryDto categoryDto2;
        for (CategoryDto categoryDto2 : categoryResult) {
            if (!categoryDto2.getCategory().equals(category)) continue;
            return categoryDto2;
        }
        categoryDto2 = new CategoryDto();
        categoryDto2.setCategory(category);
        categoryResult.add(categoryDto2);
        return categoryDto2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CountResult countFile(IFile file, List<CategoryDto> categoryResult) {
        try {
            StepCounter counter = StepCounterFactory.getCounter(file.getName());
            if (counter == null) {
                String[] data = new String[]{file.getFullPath().toString(), StepCounterPlugin.getResourceString("StepCountView.notSupported"), "", "", "", "", ""};
                TableItem item = new TableItem(this.fileTable, 0);
                item.setText(data);
                this.files.put(file.getFullPath().toString(), file);
                return null;
            }
            CountResult result = counter.count(file.getLocation().makeAbsolute().toFile(), file.getCharset());
            if (result == null) {
                return null;
            }
            this.results.add(result);
            String type = result.getFileType();
            String category = result.getCategory();
            long comment = result.getComment();
            long none = result.getNon();
            long step = result.getStep();
            CategoryDto categoryDto = StepCountView.getCategoryDto(categoryResult, result.getCategory());
            categoryDto.setStep(categoryDto.getStep() + result.getStep());
            categoryDto.setNone(categoryDto.getNone() + result.getNon());
            categoryDto.setComment(categoryDto.getComment() + result.getComment());
            String[] data = new String[]{file.getFullPath().toString(), type, category, String.valueOf(step), String.valueOf(none), String.valueOf(comment), String.valueOf(step + none + comment)};
            TableItem item = new TableItem(this.fileTable, 0);
            item.setText(data);
            this.files.put(file.getFullPath().toString(), file);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(String.valueOf(file.getName()) + "\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff01");
            return null;
        }
    }

    private CountResult countFolder(IFolder folder, List<CategoryDto> categoryResult) {
        CountResult result = new CountResult();
        try {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                CountResult count;
                if (children[i] instanceof IFile) {
                    count = this.countFile((IFile)children[i], categoryResult);
                    if (count != null) {
                        result.setStep(result.getStep() + count.getStep());
                        result.setNon(result.getNon() + count.getNon());
                        result.setComment(result.getComment() + count.getComment());
                    }
                } else if (children[i] instanceof IFolder) {
                    count = this.countFolder((IFolder)children[i], categoryResult);
                    result.setStep(result.getStep() + count.getStep());
                    result.setNon(result.getNon() + count.getNon());
                    result.setComment(result.getComment() + count.getComment());
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private CountResult countPackage(IPackageFragment pkg, List<CategoryDto> categoryResult) {
        CountResult result = new CountResult();
        try {
            ICompilationUnit[] files = pkg.getCompilationUnits();
            int i = 0;
            while (i < files.length) {
                CountResult count = this.countFile((IFile)files[i].getResource(), categoryResult);
                if (count != null) {
                    result.setStep(result.getStep() + count.getStep());
                    result.setNon(result.getNon() + count.getNon());
                    result.setComment(result.getComment() + count.getComment());
                }
                ++i;
            }
            Object[] obj = pkg.getNonJavaResources();
            int i2 = 0;
            while (i2 < obj.length) {
                CountResult count = this.countFile((IFile)obj[i2], categoryResult);
                if (count != null) {
                    result.setStep(result.getStep() + count.getStep());
                    result.setNon(result.getNon() + count.getNon());
                    result.setComment(result.getComment() + count.getComment());
                }
                ++i2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void setFocus() {
        this.fileTable.setFocus();
    }

    private void updatePopupMenu1() {
        TableItem[] items = this.fileTable.getItems();
        if (items.length == 0) {
            this.selectAll1.setEnabled(false);
            this.clear1.setEnabled(false);
            this.saveExcel1.setEnabled(false);
        } else {
            this.selectAll1.setEnabled(true);
            this.clear1.setEnabled(true);
            this.saveExcel1.setEnabled(true);
        }
        TableItem[] selection = this.fileTable.getSelection();
        if (selection.length == 0) {
            this.copy1.setEnabled(false);
        } else {
            this.copy1.setEnabled(true);
        }
        this.open.setEnabled(false);
        int i = 0;
        while (i < selection.length) {
            String filePath = selection[i].getText(0);
            if (this.files.get(filePath) != null) {
                this.open.setEnabled(true);
                break;
            }
            ++i;
        }
    }

    private void updatePopupMenu2() {
        TableItem[] items = this.categoryTable.getItems();
        if (items.length == 0) {
            this.selectAll2.setEnabled(false);
            this.clear2.setEnabled(false);
            this.saveExcel2.setEnabled(false);
        } else {
            this.selectAll2.setEnabled(true);
            this.clear2.setEnabled(true);
            this.saveExcel2.setEnabled(true);
        }
        TableItem[] selection = this.categoryTable.getSelection();
        if (selection.length == 0) {
            this.copy2.setEnabled(false);
        } else {
            this.copy2.setEnabled(true);
        }
    }

    private void openEditor() {
        TableItem[] items = this.fileTable.getSelection();
        int i = 0;
        while (i < items.length) {
            try {
                String filePath = items[i].getText(0);
                if (this.files.get(filePath) != null) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)this.files.get(filePath), (boolean)true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private class TableClearListener
    extends SelectionAdapter {
        private TableClearListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            StepCountView.this.fileTable.removeAll();
            StepCountView.this.categoryTable.removeAll();
            StepCountView.this.files.clear();
            StepCountView.this.results.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableComparator
    implements Comparator<String[]> {
        private int index = 0;
        private int firstNumberColumnIndex = 0;

        public TableComparator(int index, int firstNumberColumnIndex) {
            this.index = index;
            this.firstNumberColumnIndex = firstNumberColumnIndex;
        }

        @Override
        public int compare(String[] obj1, String[] obj2) {
            String[] data1 = obj1;
            String[] data2 = obj2;
            if (data1[0].equals(total)) {
                return 1;
            }
            if (data2[0].equals(total)) {
                return -1;
            }
            if (this.index >= this.firstNumberColumnIndex) {
                long value1 = 0L;
                long value2 = 0L;
                if (data1[this.index] != null && !data1[this.index].equals("")) {
                    value1 = Long.parseLong(data1[this.index]);
                }
                if (data2[this.index] != null && !data2[this.index].equals("")) {
                    value2 = Long.parseLong(data2[this.index]);
                }
                if (value1 == value2) {
                    return 0;
                }
                if (value1 > value2) {
                    return -1;
                }
                return 1;
            }
            String value1 = data1[this.index];
            String value2 = data2[this.index];
            if (value1.length() == 0 && value2.length() == 0) {
                return 0;
            }
            if (value1.length() == 0) {
                return 1;
            }
            if (value2.length() == 0) {
                return -1;
            }
            return value1.compareTo(value2);
        }
    }

    private class TableCopyListener
    extends SelectionAdapter {
        private Table table;

        public TableCopyListener(Table table) {
            this.table = table;
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] items = this.table.getSelection();
            if (items.length == 0) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            int columnCount = this.table.getColumnCount();
            int i = 0;
            while (i < items.length) {
                int j = 0;
                while (j < columnCount) {
                    sb.append(items[i].getText(j));
                    if (j == columnCount - 1) {
                        sb.append("\n");
                    } else {
                        sb.append("\t");
                    }
                    ++j;
                }
                ++i;
            }
            TextTransfer transfer = TextTransfer.getInstance();
            StepCountView.this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{transfer});
        }
    }

    private class TableHeaderListener1
    extends SelectionAdapter {
        private TableHeaderListener1() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                TableColumn column = (TableColumn)e.getSource();
                int sortColumn = 0;
                String name = column.getText();
                if (name.equals(file)) {
                    sortColumn = 0;
                } else if (name.equals(type)) {
                    sortColumn = 1;
                } else if (name.equals(category)) {
                    sortColumn = 2;
                } else if (name.equals(step)) {
                    sortColumn = 3;
                } else if (name.equals(none)) {
                    sortColumn = 4;
                } else if (name.equals(comment)) {
                    sortColumn = 5;
                } else if (name.equals(total)) {
                    sortColumn = 6;
                }
                TableItem[] items = StepCountView.this.fileTable.getItems();
                ArrayList<String[]> list = new ArrayList<String[]>();
                int i = 0;
                while (i < items.length) {
                    list.add(new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4), items[i].getText(5), items[i].getText(6)});
                    ++i;
                }
                String[][] datas = (String[][])list.toArray((T[])new String[list.size()][]);
                Arrays.sort(datas, new TableComparator(sortColumn, 3));
                StepCountView.this.fileTable.removeAll();
                int i2 = 0;
                while (i2 < datas.length) {
                    TableItem item = new TableItem(StepCountView.this.fileTable, 0);
                    item.setText(datas[i2]);
                    ++i2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class TableHeaderListener2
    extends SelectionAdapter {
        private TableHeaderListener2() {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                TableColumn column = (TableColumn)e.getSource();
                int sortColumn = 0;
                String name = column.getText();
                if (name.equals(category)) {
                    sortColumn = 0;
                } else if (name.equals(step)) {
                    sortColumn = 1;
                } else if (name.equals(none)) {
                    sortColumn = 2;
                } else if (name.equals(comment)) {
                    sortColumn = 3;
                } else if (name.equals(total)) {
                    sortColumn = 4;
                }
                TableItem[] items = StepCountView.this.categoryTable.getItems();
                ArrayList<String[]> list = new ArrayList<String[]>();
                int i = 0;
                while (i < items.length) {
                    list.add(new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3), items[i].getText(4)});
                    ++i;
                }
                String[][] datas = (String[][])list.toArray((T[])new String[list.size()][]);
                Arrays.sort(datas, new TableComparator(sortColumn, 1));
                StepCountView.this.categoryTable.removeAll();
                int i2 = 0;
                while (i2 < datas.length) {
                    TableItem item = new TableItem(StepCountView.this.categoryTable, 0);
                    item.setText(datas[i2]);
                    ++i2;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class TableMouseListener1
    extends MouseAdapter {
        private TableMouseListener1() {
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 3) {
                StepCountView.this.updatePopupMenu1();
                StepCountView.this.filePopup.setVisible(true);
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            StepCountView.this.openEditor();
        }
    }

    private class TableMouseListener2
    extends MouseAdapter {
        private TableMouseListener2() {
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 3) {
                StepCountView.this.updatePopupMenu2();
                StepCountView.this.categoryPopup.setVisible(true);
            }
        }
    }

    private class TableOpenListener
    extends SelectionAdapter {
        private TableOpenListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            StepCountView.this.openEditor();
        }
    }

    private class TableSelectAllListener
    extends SelectionAdapter {
        private Table table;

        public TableSelectAllListener(Table table) {
            this.table = table;
        }

        public void widgetSelected(SelectionEvent e) {
            this.table.selectAll();
        }
    }
}

