/*
 * Decompiled with CFR 0.152.
 */
package tk.stepcounter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tk.stepcounter.CountResult;
import tk.stepcounter.StepCounter;

public class PythonCounter
implements StepCounter {
    private static Pattern CATEGORY_PATTERN = Pattern.compile("\\[\\[(.*?)\\]\\]");
    private static Pattern IGNORE_PATTERN = Pattern.compile("\\[\\[IGNORE\\]\\]");
    private static final String delim = "\"\"\"";

    public CountResult count(File file, String charset) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        String line = null;
        String category = "";
        long step = 0L;
        long non = 0L;
        long comment = 0L;
        boolean areaFlag = false;
        boolean objectStartingFlag = true;
        while ((line = reader.readLine()) != null) {
            Matcher matcher;
            if (category.length() == 0 && (matcher = CATEGORY_PATTERN.matcher(line)).find()) {
                category = matcher.group(1);
            }
            if (IGNORE_PATTERN.matcher(line).find()) {
                return null;
            }
            String trimedLine = line.trim();
            if (areaFlag) {
                ++comment;
                if (!trimedLine.endsWith(delim)) continue;
                areaFlag = false;
                continue;
            }
            if (objectStartingFlag && trimedLine.startsWith(delim)) {
                ++comment;
                areaFlag = !trimedLine.endsWith(delim);
                continue;
            }
            objectStartingFlag = false;
            if (trimedLine.length() == 0) {
                ++non;
                continue;
            }
            if (trimedLine.indexOf(35) >= 0) {
                ++comment;
                continue;
            }
            ++step;
            if (!trimedLine.startsWith("def ") && !trimedLine.startsWith("class ")) continue;
            objectStartingFlag = true;
        }
        reader.close();
        return new CountResult(file.getName(), "py", category, step, non, comment);
    }
}

