/*
 * Decompiled with CFR 0.152.
 */
package tk.stepcounter.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import tk.stepcounter.Main;
import tk.stepcounter.format.FormatterFactory;

public class StepCounterTask
extends Task {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private String format = null;
    private String output = null;
    private String encoding = null;

    public void execute() throws BuildException {
        ArrayList<File> files = new ArrayList<File>();
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = this.filesets.get(i);
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            scanner.scan();
            File baseDir = scanner.getBasedir();
            String[] includeFile = scanner.getIncludedFiles();
            int j = 0;
            while (j < includeFile.length) {
                files.add(new File(baseDir, includeFile[j]));
                ++j;
            }
            ++i;
        }
        try {
            Main main = new Main();
            main.setFiles(files.toArray(new File[files.size()]));
            main.setFormatter(FormatterFactory.getFormatter(this.format));
            if (this.output != null && !this.output.equals("")) {
                main.setOutput(new FileOutputStream(new File(this.output)));
            }
            System.out.println(String.valueOf(files.size()) + "\u30d5\u30a1\u30a4\u30eb");
            if (this.encoding == null || this.encoding.length() == 0) {
                this.encoding = System.getProperty("file.encoding");
            }
            main.executeCount(this.encoding);
            if (this.output != null && !this.output.equals("")) {
                System.out.println(String.valueOf(new File(this.output).getAbsolutePath()) + "\u306b\u30ab\u30a6\u30f3\u30c8\u7d50\u679c\u3092\u51fa\u529b\u3057\u307e\u3057\u305f\u3002");
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void addFileSet(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

