/*
 * Decompiled with CFR 0.152.
 */
package tk.stepcounter.format;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.fisshplate.template.FPTemplate;
import tk.eclipse.plugin.stepcounter.CategoryDto;
import tk.stepcounter.CountResult;
import tk.stepcounter.Util;
import tk.stepcounter.format.ResultFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelFormatter
implements ResultFormatter {
    @Override
    public byte[] format(CountResult[] result) {
        try {
            InputStream in = ExcelFormatter.class.getResourceAsStream("ExcelFormatter.xls");
            long totalStep = 0L;
            long totalNone = 0L;
            long totalComment = 0L;
            ArrayList<CategoryDto> categories = new ArrayList<CategoryDto>();
            CountResult[] countResultArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                CountResult resultDto = countResultArray[n2];
                CategoryDto categoryDto = ExcelFormatter.getCategoryDto(categories, resultDto.getCategory());
                categoryDto.setStep(categoryDto.getStep() + resultDto.getStep());
                categoryDto.setStep(categoryDto.getNone() + resultDto.getNon());
                categoryDto.setStep(categoryDto.getComment() + resultDto.getComment());
                totalStep += resultDto.getStep();
                totalNone += resultDto.getNon();
                totalComment += resultDto.getComment();
                ++n2;
            }
            Collections.sort(categories, new Comparator<CategoryDto>(){

                @Override
                public int compare(CategoryDto o1, CategoryDto o2) {
                    if (o1.getCategory().length() == 0 && o2.getCategory().length() == 0) {
                        return 0;
                    }
                    if (o1.getCategory().length() == 0) {
                        return 1;
                    }
                    if (o2.getCategory().length() == 0) {
                        return -1;
                    }
                    return o1.getCategory().compareTo(o2.getCategory());
                }
            });
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("results", result);
            data.put("categories", categories);
            data.put("totalStep", totalStep);
            data.put("totalNone", totalNone);
            data.put("totalComment", totalComment);
            return ExcelFormatter.merge(in, data);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static byte[] merge(InputStream in, Map<String, Object> data) throws Exception {
        HSSFWorkbook wb;
        FPTemplate template = new FPTemplate();
        try {
            wb = template.process(in, data);
        }
        finally {
            Util.close(in);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        wb.write((OutputStream)out);
        return out.toByteArray();
    }

    private static CategoryDto getCategoryDto(List<CategoryDto> categoryResult, String category) {
        CategoryDto categoryDto2;
        for (CategoryDto categoryDto2 : categoryResult) {
            if (!categoryDto2.getCategory().equals(category)) continue;
            return categoryDto2;
        }
        categoryDto2 = new CategoryDto();
        categoryDto2.setCategory(category);
        categoryResult.add(categoryDto2);
        return categoryDto2;
    }
}

