/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jp.sf.amateras.mirage.annotation.Transient;
import jp.sf.amateras.mirage.bean.PropertyWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyWrapperImpl
implements PropertyWrapper {
    private String name;
    private Field field;
    private Method getter;
    private Method setter;

    public PropertyWrapperImpl(String name, Method getter, Method setter, Field field) {
        this.name = name;
        this.getter = getter;
        this.setter = setter;
        this.field = field;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        if (this.setter != null) {
            return this.setter.getParameterTypes()[0];
        }
        if (this.getter != null) {
            return this.getter.getReturnType();
        }
        if (this.field != null) {
            return this.field.getType();
        }
        return null;
    }

    @Override
    public void set(Object instance, Object value) throws IllegalAccessException, InvocationTargetException {
        if (this.setter != null) {
            this.setter.invoke(instance, value);
            return;
        }
        if (this.field != null) {
            this.field.set(instance, value);
            return;
        }
    }

    @Override
    public Object get(Object instance) throws IllegalAccessException, InvocationTargetException {
        if (this.getter != null) {
            return this.getter.invoke(instance, new Object[0]);
        }
        if (this.field != null) {
            return this.field.get(instance);
        }
        return null;
    }

    @Override
    public boolean isReadable() {
        return this.getter != null || this.field != null && Modifier.isPublic(this.field.getModifiers());
    }

    @Override
    public boolean isWritable() {
        return this.setter != null || this.field != null && Modifier.isPublic(this.field.getModifiers());
    }

    @Override
    public boolean isTransient() {
        Transient ann = this.getAnnotation(Transient.class);
        if (ann != null) {
            return true;
        }
        if (this.field != null) {
            return Modifier.isTransient(this.field.getModifiers());
        }
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        T ann = null;
        if (this.setter != null) {
            ann = this.setter.getAnnotation(type);
        }
        if (ann == null && this.getter != null) {
            ann = this.getter.getAnnotation(type);
        }
        if (ann == null && this.field != null) {
            ann = this.field.getAnnotation(type);
        }
        return ann;
    }

    @Override
    public Method getGetterMethod() {
        return this.getter;
    }

    @Override
    public void setGetterMethod(Method getter) {
        this.getter = getter;
    }

    @Override
    public Method getSetterMethod() {
        return this.setter;
    }

    @Override
    public void setSetterMethod(Method setter) {
        this.setter = setter;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public void setField(Field field) {
        this.field = field;
    }
}

