/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.tool;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jp.sf.amateras.mirage.annotation.Column;
import jp.sf.amateras.mirage.annotation.PrimaryKey;
import jp.sf.amateras.mirage.annotation.Table;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.type.BigDecimalValueType;
import jp.sf.amateras.mirage.type.BooleanPrimitiveValueType;
import jp.sf.amateras.mirage.type.BooleanValueType;
import jp.sf.amateras.mirage.type.ByteArrayValueType;
import jp.sf.amateras.mirage.type.DoublePrimitiveValueType;
import jp.sf.amateras.mirage.type.DoubleValueType;
import jp.sf.amateras.mirage.type.FloatPrimitiveValueType;
import jp.sf.amateras.mirage.type.FloatValueType;
import jp.sf.amateras.mirage.type.IntegerPrimitiveValueType;
import jp.sf.amateras.mirage.type.IntegerValueType;
import jp.sf.amateras.mirage.type.LongPrimitiveValueType;
import jp.sf.amateras.mirage.type.LongValueType;
import jp.sf.amateras.mirage.type.ShortPrimitiveValueType;
import jp.sf.amateras.mirage.type.ShortValueType;
import jp.sf.amateras.mirage.type.SqlDateValueType;
import jp.sf.amateras.mirage.type.StringValueType;
import jp.sf.amateras.mirage.type.TimeValueType;
import jp.sf.amateras.mirage.type.TimestampValueType;
import jp.sf.amateras.mirage.type.UtilDateValueType;
import jp.sf.amateras.mirage.type.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityGen {
    private String packageName;
    private NameConverter nameConverter;
    private List<ValueType<?>> valueTypes = new ArrayList();
    private Dialect dialect;
    private PrimaryKey.GenerationType generationType;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public EntityGen() {
        this.addValueType(new StringValueType());
        this.addValueType(new IntegerValueType());
        this.addValueType(new IntegerPrimitiveValueType());
        this.addValueType(new LongValueType());
        this.addValueType(new LongPrimitiveValueType());
        this.addValueType(new ShortValueType());
        this.addValueType(new ShortPrimitiveValueType());
        this.addValueType(new DoubleValueType());
        this.addValueType(new DoublePrimitiveValueType());
        this.addValueType(new FloatValueType());
        this.addValueType(new FloatPrimitiveValueType());
        this.addValueType(new BooleanValueType());
        this.addValueType(new BooleanPrimitiveValueType());
        this.addValueType(new BigDecimalValueType());
        this.addValueType(new SqlDateValueType());
        this.addValueType(new UtilDateValueType());
        this.addValueType(new TimeValueType());
        this.addValueType(new TimestampValueType());
        this.addValueType(new ByteArrayValueType());
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setNameConverter(NameConverter nameConverter) {
        this.nameConverter = nameConverter;
    }

    public void addValueType(ValueType<?> valueType) {
        this.valueTypes.add(valueType);
    }

    public void setGenerationType(PrimaryKey.GenerationType generationType) {
        this.generationType = generationType;
    }

    public String getEntitySource(Connection conn, String tableName, String catalog, String schema) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(this.packageName).append(";").append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        EntityGen.appendImport(sb, Table.class);
        EntityGen.appendImport(sb, Column.class);
        EntityGen.appendImport(sb, PrimaryKey.class);
        EntityGen.appendImport(sb, PrimaryKey.GenerationType.class);
        sb.append(LINE_SEPARATOR);
        sb.append("@Table(name=\"").append(tableName).append("\")").append(LINE_SEPARATOR);
        sb.append("public class ").append(EntityGen.tableToEntity(tableName)).append(" {").append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        DatabaseMetaData meta = conn.getMetaData();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        ResultSet keys = meta.getPrimaryKeys(catalog, schema, tableName);
        while (keys.next()) {
            String columnName = keys.getString("COLUMN_NAME");
            primaryKeys.add(columnName);
        }
        keys.close();
        ResultSet columns = meta.getColumns(catalog, schema, tableName, "%");
        while (columns.next()) {
            String columnName = columns.getString("COLUMN_NAME");
            int sqlType = columns.getInt("DATA_TYPE");
            if (primaryKeys.contains(columnName)) {
                sb.append("    @PrimaryKey");
                if (this.generationType == null) {
                    this.generationType = PrimaryKey.GenerationType.APPLICATION;
                }
                sb.append("(generationType=GenerationType.").append(this.generationType.name());
                if (this.generationType == PrimaryKey.GenerationType.SEQUENCE) {
                    sb.append(", generator=\"").append(tableName).append("_").append(columnName).append("_SEQ\"");
                }
                sb.append(")");
                sb.append(LINE_SEPARATOR);
            }
            sb.append("    @Column(name=\"").append(columnName).append("\")").append(LINE_SEPARATOR);
            sb.append("    public ").append(this.getJavaTypeName(sqlType)).append(" ").append(this.nameConverter.columnToProperty(columnName)).append(";").append(LINE_SEPARATOR);
            sb.append(LINE_SEPARATOR);
        }
        columns.close();
        sb.append("}").append(LINE_SEPARATOR);
        return sb.toString();
    }

    public void saveEntitySource(File srcDir, String charset, Connection conn, String tableName, String catalog, String schema) throws SQLException, IOException {
        String source = this.getEntitySource(conn, tableName, catalog, schema);
        String packageDir = this.packageName.replace('.', '/');
        String fileName = packageDir + "/" + EntityGen.tableToEntity(tableName) + ".java";
        File file = new File(srcDir, fileName);
        EntityGen.createDir(file.getParentFile());
        FileOutputStream out = new FileOutputStream(file);
        out.write(source.getBytes(charset));
        out.close();
    }

    private static void createDir(File dir) {
        if (!dir.getParentFile().exists()) {
            EntityGen.createDir(dir.getParentFile());
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    private String getJavaTypeName(int sqlType) {
        for (ValueType<?> valueType : this.getValueTypes()) {
            Class<?> type = valueType.getJavaType(sqlType);
            if (type == null) continue;
            String typeName = type.getName();
            typeName = typeName.replaceFirst("^java\\.lang\\.", "");
            return typeName;
        }
        return "String";
    }

    private List<ValueType<?>> getValueTypes() {
        ArrayList valueTypes = new ArrayList();
        if (this.dialect.getValueType() != null) {
            valueTypes.add(this.dialect.getValueType());
        }
        for (ValueType<?> valueType : this.valueTypes) {
            valueTypes.add(valueType);
        }
        return valueTypes;
    }

    private static void appendImport(StringBuilder sb, Class<?> clazz) {
        sb.append("import ").append(clazz.getName().replace('$', '.')).append(";").append(LINE_SEPARATOR);
    }

    private static String tableToEntity(String tableName) {
        StringBuilder sb = new StringBuilder();
        boolean uppercase = true;
        for (int i = 0; i < tableName.length(); ++i) {
            String letter = tableName.substring(i, i + 1);
            if (letter.equals("_")) {
                uppercase = true;
                continue;
            }
            if (uppercase) {
                sb.append(letter.toUpperCase());
            } else {
                sb.append(letter.toLowerCase());
            }
            uppercase = false;
        }
        return sb.toString();
    }
}

