/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.type;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValueType<T>
implements ValueType<T> {
    protected static final int TYPE_UNKNOWN = Integer.MIN_VALUE;
    private static Map<Class<?>, Integer> javaTypeToSqlTypeMap = new HashMap(32);
    private final Class<T> type;

    public static int javaTypeToSqlType(Class<?> javaType) {
        Integer sqlType = javaTypeToSqlTypeMap.get(javaType);
        if (sqlType != null) {
            return sqlType;
        }
        if (Number.class.isAssignableFrom(javaType)) {
            return 2;
        }
        if (AbstractValueType.isStringValue(javaType)) {
            return 12;
        }
        if (AbstractValueType.isDateValue(javaType) || Calendar.class.isAssignableFrom(javaType)) {
            return 93;
        }
        return Integer.MIN_VALUE;
    }

    private static boolean isStringValue(Class<?> inValueType) {
        return CharSequence.class.isAssignableFrom(inValueType) || StringWriter.class.isAssignableFrom(inValueType);
    }

    private static boolean isDateValue(Class<?> inValueType) {
        return java.util.Date.class.isAssignableFrom(inValueType) && !Date.class.isAssignableFrom(inValueType) && !Time.class.isAssignableFrom(inValueType) && !Timestamp.class.isAssignableFrom(inValueType);
    }

    protected static boolean isPrimitive(Class<?> type) {
        return type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE || type == Double.TYPE || type == Float.TYPE || type == Boolean.TYPE;
    }

    public AbstractValueType(Class<T> type) {
        Validate.notNull(type);
        this.type = type;
    }

    @Override
    public boolean isSupport(Class<?> type) {
        return this.type == type;
    }

    @Override
    public Class<?> getJavaType(int sqlType) {
        for (Map.Entry<Class<?>, Integer> entry : javaTypeToSqlTypeMap.entrySet()) {
            if (sqlType != entry.getValue() || AbstractValueType.isPrimitive(entry.getKey())) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void registerOutParameter(Class<?> type, CallableStatement cs, int index) throws SQLException {
        int sqlType = AbstractValueType.javaTypeToSqlType(type);
        cs.registerOutParameter(index, sqlType);
    }

    @Override
    public void registerOutParameter(Class<?> type, CallableStatement cs, String parameterName) throws SQLException {
        int sqlType = AbstractValueType.javaTypeToSqlType(type);
        cs.registerOutParameter(parameterName, sqlType);
    }

    protected void setNull(Class<?> type, PreparedStatement stmt, int index) throws SQLException {
        int sqlType = AbstractValueType.javaTypeToSqlType(type);
        stmt.setNull(index, sqlType);
    }

    @Override
    public T getDefaultValue() {
        return null;
    }

    static {
        javaTypeToSqlTypeMap.put(Byte.TYPE, new Integer(-6));
        javaTypeToSqlTypeMap.put(Byte.class, new Integer(-6));
        javaTypeToSqlTypeMap.put(Short.TYPE, new Integer(5));
        javaTypeToSqlTypeMap.put(Short.class, new Integer(5));
        javaTypeToSqlTypeMap.put(Integer.TYPE, new Integer(4));
        javaTypeToSqlTypeMap.put(Integer.class, new Integer(4));
        javaTypeToSqlTypeMap.put(Long.TYPE, new Integer(-5));
        javaTypeToSqlTypeMap.put(Long.class, new Integer(-5));
        javaTypeToSqlTypeMap.put(BigInteger.class, new Integer(-5));
        javaTypeToSqlTypeMap.put(Float.TYPE, new Integer(6));
        javaTypeToSqlTypeMap.put(Float.class, new Integer(6));
        javaTypeToSqlTypeMap.put(Double.TYPE, new Integer(8));
        javaTypeToSqlTypeMap.put(Double.class, new Integer(8));
        javaTypeToSqlTypeMap.put(BigDecimal.class, new Integer(3));
        javaTypeToSqlTypeMap.put(Date.class, new Integer(91));
        javaTypeToSqlTypeMap.put(Time.class, new Integer(92));
        javaTypeToSqlTypeMap.put(Timestamp.class, new Integer(93));
        javaTypeToSqlTypeMap.put(Blob.class, new Integer(2004));
        javaTypeToSqlTypeMap.put(byte[].class, new Integer(2004));
        javaTypeToSqlTypeMap.put(Clob.class, new Integer(2005));
    }
}

