/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.sf.amateras.mirage.type.AbstractValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanPrimitiveValueType
extends AbstractValueType<Boolean> {
    public BooleanPrimitiveValueType() {
        super(Boolean.TYPE);
    }

    @Override
    public Boolean get(Class<? extends Boolean> type, ResultSet rs, int columnIndex) throws SQLException {
        return rs.getBoolean(columnIndex);
    }

    @Override
    public Boolean get(Class<? extends Boolean> type, ResultSet rs, String columnName) throws SQLException {
        return rs.getBoolean(columnName);
    }

    @Override
    public void set(Class<? extends Boolean> type, PreparedStatement stmt, Boolean value, int index) throws SQLException {
        if (value == null) {
            this.setNull(type, stmt, index);
        } else {
            stmt.setBoolean(index, value);
        }
    }

    @Override
    public Boolean get(Class<? extends Boolean> type, CallableStatement cs, int index) throws SQLException {
        Boolean value = cs.getBoolean(index);
        if (value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }

    @Override
    public Boolean get(Class<? extends Boolean> type, CallableStatement cs, String parameterName) throws SQLException {
        Boolean value = cs.getBoolean(parameterName);
        if (value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }

    @Override
    public Boolean getDefaultValue() {
        return false;
    }
}

