/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.type;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.sf.amateras.mirage.type.AbstractValueType;
import jp.sf.amateras.mirage.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayValueType
extends AbstractValueType<byte[]> {
    public static void main(String[] args) {
        Class<byte[]> clazz = byte[].class;
        System.out.println(clazz.isArray());
        System.out.println(clazz.getComponentType() == Byte.TYPE);
    }

    public ByteArrayValueType() {
        super(byte[].class);
    }

    @Override
    public boolean isSupport(Class<?> type) {
        return type.isArray() && type.getComponentType() == Byte.TYPE;
    }

    @Override
    public byte[] get(Class<? extends byte[]> type, ResultSet rs, int columnIndex) throws SQLException {
        if (rs.getObject(columnIndex) == null) {
            return null;
        }
        return IOUtil.readStream(rs.getBinaryStream(columnIndex));
    }

    @Override
    public byte[] get(Class<? extends byte[]> type, ResultSet rs, String columnName) throws SQLException {
        if (rs.getObject(columnName) == null) {
            return null;
        }
        return IOUtil.readStream(rs.getBinaryStream(columnName));
    }

    @Override
    public void set(Class<? extends byte[]> type, PreparedStatement stmt, byte[] value, int index) throws SQLException {
        if (value == null) {
            this.setNull(type, stmt, index);
        } else {
            stmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(value), value.length);
        }
    }

    @Override
    public byte[] get(Class<? extends byte[]> type, CallableStatement cs, int index) throws SQLException {
        Blob blob = cs.getBlob(index);
        return IOUtil.readStream(blob.getBinaryStream());
    }

    @Override
    public byte[] get(Class<? extends byte[]> type, CallableStatement cs, String parameterName) throws SQLException {
        Blob blob = cs.getBlob(parameterName);
        return IOUtil.readStream(blob.getBinaryStream());
    }
}

