/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.sf.amateras.mirage.type.AbstractValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatPrimitiveValueType
extends AbstractValueType<Float> {
    public FloatPrimitiveValueType() {
        super(Float.TYPE);
    }

    @Override
    public Float get(Class<? extends Float> type, ResultSet rs, int columnIndex) throws SQLException {
        return Float.valueOf(rs.getFloat(columnIndex));
    }

    @Override
    public Float get(Class<? extends Float> type, ResultSet rs, String columnName) throws SQLException {
        return Float.valueOf(rs.getFloat(columnName));
    }

    @Override
    public void set(Class<? extends Float> type, PreparedStatement stmt, Float value, int index) throws SQLException {
        if (value == null) {
            this.setNull(type, stmt, index);
        } else {
            stmt.setFloat(index, value.floatValue());
        }
    }

    @Override
    public Float get(Class<? extends Float> type, CallableStatement cs, int index) throws SQLException {
        Float value = Float.valueOf(cs.getFloat(index));
        if (value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }

    @Override
    public Float get(Class<? extends Float> type, CallableStatement cs, String parameterName) throws SQLException {
        Float value = Float.valueOf(cs.getFloat(parameterName));
        if (value != null && cs.wasNull()) {
            value = null;
        }
        return value;
    }

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(0.0f);
    }
}

