/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import jp.sf.amateras.mirage.exception.IORuntimeException;

public class IOUtil {
    public static byte[] readStream(InputStream in) {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int length = 0;
            while ((length = in.read(buf)) != -1) {
                out.write(buf, 0, length);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(out);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream in = null;
        try {
            in = cl.getResourceAsStream(path);
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException ex) {
            Properties properties = null;
            return properties;
        }
        finally {
            IOUtil.closeQuietly(in);
        }
    }
}

