package jp.sf.amateras.stepcounter;

import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import jp.sf.amateras.stepcounter.format.ExcelFormatter;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

/**
 * JEgʂ\邽߂ViewPart
 *
 * @see ViewPart
 */
public class StepCountView extends ViewPart {

	private TabFolder				tabFolder;
	private Table					fileTable;
	private Table					categoryTable;
	private Menu					filePopup;
	private Menu					categoryPopup;
	private MenuItem				copy1;
	private MenuItem				copy2;
	private MenuItem				saveExcel1;
	private MenuItem				saveExcel2;
	private MenuItem				selectAll1;
	private MenuItem				selectAll2;
	private MenuItem				clear1;
	private MenuItem				clear2;
	private MenuItem				open;
	private Clipboard				clipboard;

	private static final String		FILE		= StepCounterPlugin.getResourceString("StepCountView.columnName");		//$NON-NLS-1$
	private static final String		TYPE		= StepCounterPlugin.getResourceString("StepCountView.columnType");		//$NON-NLS-1$
	private static final String		CATEGORY	= StepCounterPlugin.getResourceString("StepCountView.columnCategory");	//$NON-NLS-1$
	private static final String		STEP		= StepCounterPlugin.getResourceString("StepCountView.columnStep");		//$NON-NLS-1$
	private static final String		NONE		= StepCounterPlugin.getResourceString("StepCountView.columnNone");		//$NON-NLS-1$
	private static final String		COMMENT		= StepCounterPlugin.getResourceString("StepCountView.columnComment");	//$NON-NLS-1$
	private static final String		TOTAL		= StepCounterPlugin.getResourceString("StepCountView.columnTotal");	//$NON-NLS-1$

	private HashMap<String, IFile>	files		= new HashMap<String, IFile>();

	private List<CountResult>		results		= new ArrayList<CountResult>();

	/**
	 * RXgN^
	 */
	public StepCountView() {
		super();
	}

	/**
	 * ViewPart̒g쐬B
	 *
	 * @see ViewPart#createPartControl
	 */
	public void createPartControl(Composite parent) {
		// ^u쐬
		tabFolder = new TabFolder(parent, SWT.NULL);

		TabItem tabItem1 = new TabItem(tabFolder, SWT.NULL);
		tabItem1.setText(StepCounterPlugin.getResourceString("StepCountView.tabFile"));

		Composite composite1 = new Composite(tabFolder, SWT.NULL);
		composite1.setLayout(new FillLayout());
		tabItem1.setControl(composite1);

		// t@Cʂ̃e[u쐬
		fileTable = new Table(composite1, SWT.FULL_SELECTION | SWT.MULTI);
		fileTable.setHeaderVisible(true);
		fileTable.setLinesVisible(true);
		String[] cols1 = { FILE, TYPE, CATEGORY, STEP, NONE, COMMENT, TOTAL };
		for (int i = 0; i < cols1.length; i++) {
			TableColumn col = null;
			if (i == 0 || i == 1 || i == 2) {
				col = new TableColumn(fileTable, SWT.LEFT);
			} else {
				col = new TableColumn(fileTable, SWT.RIGHT);
			}
			col.setText(cols1[i]);
			if (i == 0) {
				col.setWidth(250);
			} else {
				col.setWidth(80);
			}
			col.addSelectionListener(new FileTableHeaderListener());
		}

		// JeSʂ̃e[u쐬
		TabItem tabItem2 = new TabItem(tabFolder, SWT.NULL);
		tabItem2.setText(StepCounterPlugin.getResourceString("StepCountView.tabCategory"));

		Composite composite2 = new Composite(tabFolder, SWT.NULL);
		composite2.setLayout(new FillLayout());
		tabItem2.setControl(composite2);

		categoryTable = new Table(composite2, SWT.FULL_SELECTION | SWT.MULTI);
		categoryTable.setHeaderVisible(true);
		categoryTable.setLinesVisible(true);
		String[] cols2 = { CATEGORY, STEP, NONE, COMMENT, TOTAL };
		for (int i = 0; i < cols2.length; i++) {
			TableColumn col = null;
			if (i == 0) {
				col = new TableColumn(categoryTable, SWT.LEFT);
			} else {
				col = new TableColumn(categoryTable, SWT.RIGHT);
			}
			col.setText(cols2[i]);
			if (i == 0) {
				col.setWidth(250);
			} else {
				col.setWidth(80);
			}
			col.addSelectionListener(new CategoryTableHeaderListener());
		}

		// Nbv{[h̏
		clipboard = new Clipboard(parent.getDisplay());

		// e[uɃ|bvAbvj[ǉ
		{
			filePopup = new Menu(fileTable.getShell(), SWT.POP_UP);

			open = new MenuItem(filePopup, SWT.PUSH);
			open.setText(StepCounterPlugin.getResourceString("StepCountView.menuOpen")); //$NON-NLS-1$
			open.addSelectionListener(new TableOpenListener());

			copy1 = new MenuItem(filePopup, SWT.PUSH);
			copy1.setText(StepCounterPlugin.getResourceString("StepCountView.menuCopy")); //$NON-NLS-1$
			copy1.addSelectionListener(new TableCopyListener(fileTable,
					clipboard));

			saveExcel1 = new MenuItem(filePopup, SWT.PUSH);
			saveExcel1.setText(StepCounterPlugin.getResourceString("StepCountView.menuExcel")); //$NON-NLS-1$
			saveExcel1.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					saveToExcel();
				}
			});

			selectAll1 = new MenuItem(filePopup, SWT.PUSH);
			selectAll1.setText(StepCounterPlugin.getResourceString("StepCountView.menuSelectAll")); //$NON-NLS-1$
			selectAll1.addSelectionListener(new TableSelectAllListener(
					fileTable));

			new MenuItem(filePopup, SWT.SEPARATOR);

			clear1 = new MenuItem(filePopup, SWT.PUSH);
			clear1.setText(StepCounterPlugin.getResourceString("StepCountView.menuClear")); //$NON-NLS-1$
			clear1.addSelectionListener(new TableClearListener());

			fileTable.addMouseListener(new TableMouseListener1());
		}
		{
			categoryPopup = new Menu(categoryTable.getShell(), SWT.POP_UP);

			copy2 = new MenuItem(categoryPopup, SWT.PUSH);
			copy2.setText(StepCounterPlugin.getResourceString("StepCountView.menuCopy")); //$NON-NLS-1$
			copy2.addSelectionListener(new TableCopyListener(categoryTable,
					clipboard));

			saveExcel2 = new MenuItem(categoryPopup, SWT.PUSH);
			saveExcel2.setText(StepCounterPlugin.getResourceString("StepCountView.menuExcel")); //$NON-NLS-1$
			saveExcel2.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					saveToExcel();
				}
			});

			selectAll2 = new MenuItem(categoryPopup, SWT.PUSH);
			selectAll2.setText(StepCounterPlugin.getResourceString("StepCountView.menuSelectAll")); //$NON-NLS-1$
			selectAll2.addSelectionListener(new TableSelectAllListener(
					categoryTable));

			new MenuItem(categoryPopup, SWT.SEPARATOR);

			clear2 = new MenuItem(categoryPopup, SWT.PUSH);
			clear2.setText(StepCounterPlugin.getResourceString("StepCountView.menuClear")); //$NON-NLS-1$
			clear2.addSelectionListener(new TableClearListener());

			categoryTable.addMouseListener(new TableMouseListener2());
		}
	}

	private void saveToExcel() {
		// GNX|[g̃t@Cw
		FileDialog dialog = new FileDialog(
				Display.getDefault().getActiveShell(), SWT.SAVE);
		dialog.setFilterExtensions(new String[] { "*.xls" });
		String path = dialog.open();
		if (path != null) {
			ExcelFormatter formatter = new ExcelFormatter();
			byte[] data = formatter.format(results.toArray(new CountResult[results.size()]));
			FileOutputStream out = null;
			try {
				out = new FileOutputStream(path);
				out.write(data);
			} catch (Exception ex) {
				// TODO RuntimeExceptionł̂H
				throw new RuntimeException(ex);
			} finally {
				Util.close(out);
			}
		}
	}

	/**
	 * JEgs
	 *
	 * @param selection ISelection
	 */
	public void count(ISelection selection) {
		// ׂč폜
		fileTable.removeAll();
		files.clear();
		results.clear();
		categoryTable.removeAll();

		if (selection != null && selection instanceof IStructuredSelection) {
			IStructuredSelection iSel = (IStructuredSelection)selection;

			@SuppressWarnings("unchecked")
			Iterator<Object> ite = iSel.iterator();

			long totalStep = 0;
			long totalComment = 0;
			long totalNone = 0;
			List<CategoryStepDto> categoryResult = new ArrayList<CategoryStepDto>();

			while (ite.hasNext()) {
				Object obj = ite.next();
				CountResult result = null;
				if (obj instanceof ICompilationUnit) {
					// Java\[Xt@CiJDTj
					ICompilationUnit file = (ICompilationUnit)obj;
					result = countFile((IFile)file.getResource(), categoryResult);
				} else if (obj instanceof IPackageFragment) {
					// JavapbP[WiJDTj
					IPackageFragment pkg = (IPackageFragment)obj;
					result = countPackage(pkg, categoryResult);
				} else if (obj instanceof IFile) {
					// t@C
					result = countFile((IFile)obj, categoryResult);
				} else if (obj instanceof IContainer) {
					// fBNg
					result = countFolder((IContainer)obj, categoryResult);
				}
				if (result != null) {
					totalStep += result.getStep();
					totalNone += result.getNon();
					totalComment += result.getComment();
				}
			}
			{
				// t@CPʂ̍vs\
				String[] data = {
						TOTAL,
						"", //$NON-NLS-1$
						"", //$NON-NLS-1$
						String.valueOf(totalStep), String.valueOf(totalNone),
						String.valueOf(totalComment),
						String.valueOf(totalStep + totalNone + totalComment) };
				TableItem item = new TableItem(fileTable, SWT.NULL);
				item.setText(data);
			}

			// JeSʂ̏Wvl\
			totalStep = 0;
			totalNone = 0;
			totalComment = 0;

			// JeS\[g
			CategoryDto.sort(categoryResult);

			for (CategoryStepDto categoryDto : categoryResult) {
				String[] categoryData = {
						categoryDto.getCategory(),
						String.valueOf(categoryDto.getStep()),
						String.valueOf(categoryDto.getNone()),
						String.valueOf(categoryDto.getComment()),
						String.valueOf(categoryDto.getStep()
								+ categoryDto.getNone()
								+ categoryDto.getComment()), };

				TableItem categoryItem = new TableItem(categoryTable, SWT.NULL);
				categoryItem.setText(categoryData);

				totalStep += categoryDto.getStep();
				totalNone += categoryDto.getNone();
				totalComment += categoryDto.getComment();
			}
			{
				// JeSPʂ̍vs\
				String[] data = { TOTAL, String.valueOf(totalStep),
						String.valueOf(totalNone),
						String.valueOf(totalComment),
						String.valueOf(totalStep + totalNone + totalComment) };
				TableItem item = new TableItem(categoryTable, SWT.NULL);
				item.setText(data);
			}
		}
	}

	/**
	 * Pt@CJEg
	 *
	 * @param file t@C
	 * @return ̃t@C̃JEg
	 */
	private CountResult countFile(IFile file, List<CategoryStepDto> categoryResult) {
		if(files.containsValue(file)){
			return null;
		}
		try {
			StepCounter counter = StepCounterFactory.getCounter(file.getName());
			if (counter != null) {
				// ΉJE^݂ꍇ
				CountResult result = counter.count(
						file.getLocation().makeAbsolute().toFile(),
						file.getCharset());
				if (result == null) {
					// JEgΏۊO
					return null;
				}

				results.add(result);

				String type = result.getFileType();
				String category = result.getCategory();
				long comment = result.getComment();
				long none = result.getNon();
				long step = result.getStep();

				CategoryStepDto categoryDto = CategoryStepDto.getDto(categoryResult, result.getCategory());
				categoryDto.setStep(categoryDto.getStep() + result.getStep());
				categoryDto.setNone(categoryDto.getNone() + result.getNon());
				categoryDto.setComment(categoryDto.getComment() + result.getComment());

				String[] data = {
						file.getFullPath().toString(),
						//FILE.getName(),
						type, category, String.valueOf(step),
						String.valueOf(none), String.valueOf(comment),
						String.valueOf(step + none + comment) };
				TableItem item = new TableItem(fileTable, SWT.NULL);
				item.setText(data);
				files.put(file.getFullPath().toString(), file);

				return result;

			} else {
				// ΉJE^݂Ȃꍇ
				String[] data = {
						file.getFullPath().toString(),
						//FILE.getName(),
						StepCounterPlugin.getResourceString("StepCountView.notSupported"), //$NON-NLS-1$
						"", "", //$NON-NLS-1$
						"", //$NON-NLS-1$
						"", //$NON-NLS-1$
						"" //$NON-NLS-1$
				};
				TableItem item = new TableItem(fileTable, SWT.NULL);
				item.setText(data);
				files.put(file.getFullPath().toString(), file);
				return null;
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			System.out.println(file.getName() + "ŃG[܂I");
			return null;
		}
	}

	/**
	 * tH_JEg
	 *
	 * @param container tH_
	 * @return tH_̃JEgv
	 */
	private CountResult countFolder(IContainer container,
			List<CategoryStepDto> categoryResult) {
		CountResult result = new CountResult();
		try {
			IResource[] children = container.members();
			for (int i = 0; i < children.length; i++) {
				if (children[i] instanceof IFile) {
					CountResult count = countFile((IFile)children[i],
							categoryResult);
					if (count != null) {
						result.setStep(result.getStep() + count.getStep());
						result.setNon(result.getNon() + count.getNon());
						result.setComment(result.getComment()
								+ count.getComment());
					}
				} else if (children[i] instanceof IContainer) {
					CountResult count = countFolder((IContainer)children[i],
							categoryResult);
					result.setStep(result.getStep() + count.getStep());
					result.setNon(result.getNon() + count.getNon());
					result.setComment(result.getComment() + count.getComment());
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return result;
	}

	/**
	 * pbP[WJEg
	 *
	 * @param pkg pbP[W
	 * @return pbP[W̃JEgv
	 */
	private CountResult countPackage(IPackageFragment pkg, List<CategoryStepDto> categoryResult) {
		CountResult result = new CountResult();
		try {
			ICompilationUnit[] files = pkg.getCompilationUnits();
			for (int i = 0; i < files.length; i++) {
				if(this.files.containsValue(files[i].getResource())){
					return null;
				}
				CountResult count = countFile((IFile) files[i].getResource(), categoryResult);
				if (count != null) {
					result.setStep(result.getStep() + count.getStep());
					result.setNon(result.getNon() + count.getNon());
					result.setComment(result.getComment() + count.getComment());
				}
			}
			Object[] obj = pkg.getNonJavaResources();
			for (int i = 0; i < obj.length; i++) {
				CountResult count = countFile((IFile)obj[i], categoryResult);
				if (count != null) {
					result.setStep(result.getStep() + count.getStep());
					result.setNon(result.getNon() + count.getNon());
					result.setComment(result.getComment() + count.getComment());
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return result;
	}

	/**
	 * @see ViewPart#setFocus
	 */
	public void setFocus() {
		fileTable.setFocus();
	}

	/**
	 * t@Cʃe[ũ|bvAbvj[̏ԂXV܂B
	 */
	private void updatePopupMenu1() {
		// ڂPȏ゠΁uSđIvuNAvuExcelt@Cɕۑv
		TableItem[] items = fileTable.getItems();
		if (items.length == 0) {
			selectAll1.setEnabled(false);
			clear1.setEnabled(false);
			saveExcel1.setEnabled(false);
		} else {
			selectAll1.setEnabled(true);
			clear1.setEnabled(true);
			saveExcel1.setEnabled(true);
		}
		// ڂPłIĂ΁uRs[v
		TableItem[] selection = fileTable.getSelection();
		if (selection.length == 0) {
			copy1.setEnabled(false);
		} else {
			copy1.setEnabled(true);
		}
		// t@CPłIĂ΁uJv
		open.setEnabled(false);
		for (int i = 0; i < selection.length; i++) {
			String filePath = selection[i].getText(0);
			if (files.get(filePath) != null) {
				open.setEnabled(true);
				break;
			}
		}
	}

	/**
	 * JeSʃe[ũ|bvAbvj[̏ԂXV܂B
	 */
	private void updatePopupMenu2() {
		// ڂPȏ゠΁uSđIvuNAvuExcelt@Cɕۑv
		TableItem[] items = categoryTable.getItems();
		if (items.length == 0) {
			selectAll2.setEnabled(false);
			clear2.setEnabled(false);
			saveExcel2.setEnabled(false);
		} else {
			selectAll2.setEnabled(true);
			clear2.setEnabled(true);
			saveExcel2.setEnabled(true);
		}
		// ڂPłIĂ΁uRs[v
		TableItem[] selection = categoryTable.getSelection();
		if (selection.length == 0) {
			copy2.setEnabled(false);
		} else {
			copy2.setEnabled(true);
		}
	}

	/**
	 * e[uőIԂɂȂĂt@CGfB^ŊJ܂B
	 */
	private void openEditor() {
		TableItem[] items = fileTable.getSelection();
		for (int i = 0; i < items.length; i++) {
			try {
				String filePath = items[i].getText(0);
				if (files.get(filePath) != null) {
					IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
					// Eclipse 3.0Ή
					IDE.openEditor(window.getActivePage(),
							(IFile)files.get(filePath), true);
				}
			} catch (Exception ex) {
				// TODO O͈ԂĂ܂c
			}
		}
	}

	/**
	 * t@CPʂ̃e[ũwb_NbNꂽۂɃ\[gsXi
	 */
	private class FileTableHeaderListener extends SelectionAdapter {

		private int	sortColumn	= 0;

		private int	sortOrder	= TableComparator.ASC;

		public void widgetSelected(SelectionEvent e) {
			try {
				// \[gJ
				TableColumn column = (TableColumn)e.getSource();
				int selectColumn = 0;
				String name = column.getText();
				if (name.equals(FILE)) {
					selectColumn = 0;
				} else if (name.equals(TYPE)) {
					selectColumn = 1;
				} else if (name.equals(CATEGORY)) {
					selectColumn = 2;
				} else if (name.equals(STEP)) {
					selectColumn = 3;
				} else if (name.equals(NONE)) {
					selectColumn = 4;
				} else if (name.equals(COMMENT)) {
					selectColumn = 5;
				} else if (name.equals(TOTAL)) {
					selectColumn = 6;
				}

				if (this.sortColumn != selectColumn) {
					this.sortOrder = TableComparator.ASC;
				}
				this.sortColumn = selectColumn;

				// f[^ArrayListɊi[
				TableItem[] items = fileTable.getItems();
				ArrayList<String[]> list = new ArrayList<String[]>();
				for (int i = 0; i < items.length; i++) {
					list.add(new String[] { items[i].getText(0),
							items[i].getText(1), items[i].getText(2),
							items[i].getText(3), items[i].getText(4),
							items[i].getText(5), items[i].getText(6) });
				}

				// \[g
				String[][] datas = list.toArray(new String[list.size()][]);
				Arrays.sort(datas, new TableComparator(sortColumn, 3,
						TableComparator.ASC));
				this.sortOrder = this.sortOrder * -1;

				// f[^ĕ\
				fileTable.removeAll();
				for (int i = 0; i < datas.length; i++) {
					TableItem item = new TableItem(fileTable, SWT.NULL);
					item.setText(datas[i]);
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * JeSPʂ̃e[ũwb_NbNꂽۂɃ\[gsXi
	 */
	private class CategoryTableHeaderListener extends SelectionAdapter {

		private int	sortColumn	= 0;

		private int	sortOrder	= TableComparator.ASC;

		public void widgetSelected(SelectionEvent e) {
			try {
				// \[gJ
				TableColumn column = (TableColumn)e.getSource();
				int selectColumn = 0;
				String name = column.getText();
				if (name.equals(CATEGORY)) {
					selectColumn = 0;
				} else if (name.equals(STEP)) {
					selectColumn = 1;
				} else if (name.equals(NONE)) {
					selectColumn = 2;
				} else if (name.equals(COMMENT)) {
					selectColumn = 3;
				} else if (name.equals(TOTAL)) {
					selectColumn = 4;
				}

				if (this.sortColumn != selectColumn) {
					this.sortOrder = TableComparator.ASC;
				}
				this.sortColumn = selectColumn;

				// f[^ArrayListɊi[
				TableItem[] items = categoryTable.getItems();
				ArrayList<String[]> list = new ArrayList<String[]>();
				for (int i = 0; i < items.length; i++) {
					list.add(new String[] { items[i].getText(0),
							items[i].getText(1), items[i].getText(2),
							items[i].getText(3), items[i].getText(4) });
				}

				// \[g
				String[][] datas = list.toArray(new String[list.size()][]);
				Arrays.sort(datas, new TableComparator(sortColumn, 1,
						TableComparator.ASC));
				this.sortOrder = this.sortOrder * -1;

				// f[^ĕ\
				categoryTable.removeAll();
				for (int i = 0; i < datas.length; i++) {
					TableItem item = new TableItem(categoryTable, SWT.NULL);
					item.setText(datas[i]);
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
	}

	/** t@Cʃe[ũ|bvAbvj[\邽߂̃}EXXi */
	private class TableMouseListener1 extends MouseAdapter {
		public void mouseUp(MouseEvent e) {
			if (e.button == 3) {
				updatePopupMenu1();
				filePopup.setVisible(true);
			}
		}

		public void mouseDoubleClick(MouseEvent e) {
			openEditor();
		}
	}

	/** JeSʃe[ũ|bvAbvj[\邽߂̃}EXXi */
	private class TableMouseListener2 extends MouseAdapter {
		public void mouseUp(MouseEvent e) {
			if (e.button == 3) {
				updatePopupMenu2();
				categoryPopup.setVisible(true);
			}
		}
	}

	/** e[uőIꂽt@CJ߂̃Xi */
	private class TableOpenListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e) {
			openEditor();
		}
	}

	/** e[u̕\eNA邽߂̃Xi */
	private class TableClearListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e) {
			fileTable.removeAll();
			categoryTable.removeAll();
			files.clear();
			results.clear();
		}
	}
}
