/*
 * Decompiled with CFR 0.152.
 */
package tk.csv;

import java.util.Vector;

public class CSVUtil {
    private char separater = (char)44;
    private char quota = (char)34;

    public void setSeparater(char separatoer) {
        this.separater = this.separater;
    }

    public void setQuota(char quota) {
        this.quota = quota;
    }

    public char getSeparater() {
        return this.separater;
    }

    public char getQuota() {
        return this.quota;
    }

    public String formatLine(String[] csvData, boolean autoQuote) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < csvData.length) {
            String tmp = csvData[i];
            if (autoQuote) {
                tmp = this.quotation(tmp);
            } else if (tmp.indexOf(String.valueOf(this.separater)) != -1 || tmp.indexOf("\n") != -1 || tmp.indexOf("\r") != -1) {
                tmp = this.quotation(tmp);
            }
            if (i != 0) {
                sb.append(String.valueOf(this.separater));
            }
            sb.append(tmp);
            ++i;
        }
        return sb.toString();
    }

    private String quotation(String value) {
        value = this.replace(value, "\r", "\\\\r");
        value = this.replace(value, "\n", "\\\\n");
        value = this.replace(value, String.valueOf(this.quota), String.valueOf(this.quota) + String.valueOf(this.quota));
        return this.quota + value + this.quota;
    }

    private String replace(String str, String from, String to) {
        if (str == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.indexOf(from, i) == i) {
                sb.append(to);
                i = i + from.length() - 1;
            } else {
                sb.append(str.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public String[] parseLine(String line) {
        Vector<String> v = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        boolean flag = false;
        char backchar = ' ';
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (backchar == this.quota && c == this.quota) {
                sb.append(c);
            } else if (flag) {
                if (c == this.quota) {
                    if (i < line.length() - 1 && line.charAt(i + 1) != this.quota) {
                        flag = false;
                    }
                } else if (c == '\\') {
                    if (backchar == '\\') {
                        sb.append("\\");
                    }
                } else if (c == 'r' && backchar == '\\') {
                    sb.append("\r");
                } else if (c == 'n' && backchar == '\\') {
                    sb.append("\n");
                } else {
                    sb.append(c);
                }
            } else if ((backchar == this.separater || i == 0) && c == this.quota) {
                flag = true;
            } else if (c == this.separater) {
                v.add(sb.toString());
                sb = new StringBuffer();
            } else {
                sb.append(c);
            }
            backchar = c;
            ++i;
        }
        v.add(sb.toString());
        String[] ret = new String[v.size()];
        int i2 = 0;
        while (i2 < v.size()) {
            ret[i2] = (String)v.get(i2);
            ++i2;
        }
        return ret;
    }
}

