/*
 * Decompiled with CFR 0.152.
 */
package tk.csv;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import tk.csv.CSVUtil;

public class CSVWriter {
    private BufferedWriter writer;
    private CSVUtil util;

    public CSVWriter(Writer writer) {
        this.writer = new BufferedWriter(writer);
        this.util = new CSVUtil();
    }

    public void setSeparater(char separatoer) {
        this.util.setSeparater(separatoer);
    }

    public void setQuota(char quota) {
        this.util.setQuota(quota);
    }

    public char getSeparater() {
        return this.util.getSeparater();
    }

    public char getQuota() {
        return this.util.getQuota();
    }

    public void writeLine(String[] dim) throws IOException {
        this.writeLine(dim, false);
    }

    public void writeLine(String[] dim, boolean autoQuote) throws IOException {
        this.writer.write(this.util.formatLine(dim, autoQuote));
        this.writer.newLine();
    }

    public void write(String[][] dim) throws IOException {
        this.write(dim, false);
    }

    public void write(String[][] dim, boolean autoQuote) throws IOException {
        int i = 0;
        while (i < dim.length) {
            this.writeLine(dim[i], autoQuote);
            ++i;
        }
        this.writer.flush();
        this.writer.close();
    }
}

