package tk.csv;

import java.util.*;

/**
 * CSVt@C̍쐬Aǂݍ݂Ɏgpł郆[eBeBNXłB
 * ƂƂCSVReaderACSVWriter̓ŎĂłA
 * OvOpł悤APƂ̃NXƂĐ؂o܂B
 *
 * @author Naoki Takezoe
 * @version 1.2
 * @since   1.2
 */
public class CSVUtil {
	
	private char separater = ',';
	private char quota     = '"';
	
	/**
	 * RXgN^B
	 */
	public CSVUtil(){
		super();
	}
	
	/**
	 * Zp[^ݒ肵܂B
	 * ftHgł̓J}ɐݒ肳Ă܂B
	 *
	 * @param separater Zp[^
	 */
	public void setSeparater(char separatoer){
		this.separater = separater;
	}
	
	/**
	 * NI[^ݒ肵܂B
	 * ftHgł̓_uNH[e[Vɐݒ肳Ă܂B
	 *
	 * @param quota NI[^
	 */
	public void setQuota(char quota){
		this.quota = quota;
	}

	/**
	 * Zp[^擾܂B
	 *
	 * @return Zp[^
	 */
	public char getSeparater(){
		return this.separater;
	}

	/**
	 * NI[^擾܂B
	 * @return NI[^
	 */
	public char getQuota(){
		return this.quota;
	}
	
	/**
	 * CSVPs̃f[^𕶎̔zƂēnACSV`̕ɕϊĕԋp܂B
	 *
	 * @param csvData   PsCSVf[^
	 * @param autoQuote I[gNH[gsǂ
	 * @return 
	 */
	public String formatLine(String[] csvData,boolean autoQuote){
		
		StringBuffer sb = new StringBuffer();
		
		for(int i=0;i<csvData.length;i++){
			String tmp = csvData[i];

			// ɃNI[g
			if(autoQuote==true){
				tmp = quotation(tmp);
			// Zp[^s܂܂ƂNH[g
			} else if(tmp.indexOf(String.valueOf(separater))!=-1 || 
			          tmp.indexOf("\n")!=-1 || tmp.indexOf("\r")!=-1){
				tmp = quotation(tmp);
			}
			// J}
			if(i!=0){
				sb.append(String.valueOf(this.separater));
			}
			sb.append(tmp);
		}
		
		return sb.toString();
	}
	
	/**
	 * ̃NI[gs܂B
	 *
	 * @param value 
	 * @return NH[g̕
	 */
	private String quotation(String value){
		
		// sϊ
		value = replace(value,"\r","\\\\r");
		value = replace(value,"\n","\\\\n");
		
		// NI[^GXP[v
		value = replace(value,String.valueOf(this.quota),
		                      String.valueOf(this.quota)+String.valueOf(this.quota));
		
		return this.quota + value + this.quota;
	}
	
	/**
	 * ̒us\bh
	 *
	 * @param str  Ώۂ̕
	 * @param from ϊΏۂ̕
	 * @param to   ϊ̕
	 * @return ̕
	 */
	private String replace(String str,String from,String to){
		// s NULLꍇA󕶎Ԃ
		if(str==null){
			return "";
		}
		
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<str.length();i++){
			if(str.indexOf(from,i)==i){
				sb.append(to);
				i = i + from.length() - 1;
			} else {
				sb.append(str.charAt(i));
			}
		}
		return sb.toString();
	}
	
	/**
	 * 1sCSV`̕nAzɕĕԂ܂B
	 *
	 * @param line
	 * @return 
	 */
	public String[] parseLine(String line){
		
		Vector v = new Vector();
		StringBuffer sb = new StringBuffer();

		// NI[gtO
		boolean flag = false;

		// PO̕
		char backchar = ' ';

		for(int i=0;i<line.length();i++){
			char c = line.charAt(i);

			// NI[^GXP[vĂꍇ
			if(backchar==this.quota && c==this.quota){
				sb.append(c);
			// NI[^GXP[vĂȂꍇ
			} else {
				// NI[^JnĂꍇ
				if(flag==true){
					if(c==this.quota){
						if(i<line.length()-1){
							if(line.charAt(i+1)!=this.quota){
								flag=false;
							}
						}
					} else if(c=='\\'){
						if(backchar=='\\'){
							sb.append("\\");
						}
					} else if(c=='r' && backchar=='\\'){
						sb.append("\r");
						
					} else if(c=='n' && backchar=='\\'){
						sb.append("\n");
						
					} else {
						sb.append(c);
					}
				// NI[^JnĂȂꍇ
				} else {
					if((backchar==this.separater || i==0) && c==this.quota){
						flag=true;
					} else if(c==this.separater){
						v.add(sb.toString());
						sb = new StringBuffer();
					} else {
						sb.append(c);
					}
				}
			}
			backchar = c;
		}
		// s
		v.add(sb.toString());

		// zɕϊĕԂ
		String[] ret = new String[v.size()];
		for(int i=0;i<v.size();i++){
			ret[i] = (String)v.get(i);
		}
		
		return ret;
	}
	
}
