package tk.csv;

import java.io.*;

/**
 * QzCSV`ŏo͂NXłB
 *
 * @author Naoki Takezoe
 * @version 1.2
 * @since   1.0
 */
public class CSVWriter {
	
	private BufferedWriter writer;
	private CSVUtil util;
	//private boolean overwrite = true;

	/**
	 * t@Cw肵CSVWriter쐬܂B
	 *
	 * @param writer Writer
	 */
	public CSVWriter(Writer writer){
		this.writer = new BufferedWriter(writer);
		this.util   = new CSVUtil();
	}

	/**
	 * Zp[^ݒ肵܂B
	 * ftHgł̓J}ɐݒ肳Ă܂B
	 *
	 * @param separater Zp[^
	 */
	public void setSeparater(char separatoer){
		util.setSeparater(separatoer);
	}
	
	/**
	 * NI[^ݒ肵܂B
	 * ftHgł̓_uNH[e[Vɐݒ肳Ă܂B
	 *
	 * @param quota NI[^
	 */
	public void setQuota(char quota){
		util.setQuota(quota);
	}

	/**
	 * Zp[^擾܂B
	 *
	 * @return Zp[^
	 */
	public char getSeparater(){
		return util.getSeparater();
	}

	/**
	 * NI[^擾܂B
	 * @return NI[^
	 */
	public char getQuota(){
		return util.getQuota();
	}
	
	/**
	 * Ps̃f[^o̓Xg[ɏo܂B
	 * f[^̓Zp[^iftHgł̓J}jŋ؂܂A
	 * f[^ɃZp[^܂܂ꍇ̂݃NI[gs܂B
	 *
	 * @param dim CSVt@Cɏof[^i[^̔zB
	 * @exception IOException ݒɃG[ꍇB
	 */
	public void writeLine(String[] dim) throws IOException {
		this.writeLine(dim,false);
	}
	
	/**
	 * Ps̃f[^o̓Xg[ɏo܂B
	 * I[gNI[gONɂꍇ́A
	 * SẴf[^ɑ΂ɃNH[gs܂B
	 *
	 * @param dim       CSVt@Cɏof[^i[^̔zB
	 * @param autoQuote I[gNH[gsǂ
	 * @exception IOException ݒɃG[ꍇB
	 */
	public void writeLine(String[] dim,boolean autoQuote) throws IOException {
		// Pso
		this.writer.write(util.formatLine(dim,autoQuote));
		// s؂
		this.writer.newLine();
	}

	
	/**
	 * ^Qzo̓Xg[ɏo܂B
	 * f[^̓Zp[^iftHgł̓J}jŋ؂܂A
	 * f[^ɃZp[^܂܂ꍇ̂݃NI[gs܂B
	 *
	 * @param dim CSVt@Cɏof[^i[^QzB
	 * @exception IOException ݒɃG[ꍇB
	 */
	public void write(String[][] dim) throws IOException {
		this.write(dim,false);
	}
	
	/**
	 * I[gNI[g̗Lw肵ďo͂܂B
	 * I[gNI[gONɂꍇ́A
	 * SẴf[^ɑ΂ɃNH[gs܂B
	 *
	 * @param dim       CSVt@Cɏof[^i[^QzB
	 * @param autoQuote I[gNH[gsǂ
	 * @exception IOException ݒɃG[ꍇB
	 */
	public void write(String[][] dim,boolean autoQuote) throws IOException {
		
		for(int i=0;i<dim.length;i++){
			this.writeLine(dim[i],autoQuote);
		}
		this.writer.flush();
		this.writer.close();
	}
	
	/**
	 * ݃eXg
	 *
	 */
	/*
	public static void main(String[] args) throws Exception {
		
		String[][] dim = {{"aa\naaa","bbbb","cccc"},{"dddd","eeee","ffff"}};
		
		CSVWriter writer = new CSVWriter(new FileWriter(new File("./test.csv")));
		writer.write(dim);
		
	}
	*/
}