/*
 * Copyright (c) 2004, SHIRAMOTO Takeyuki
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Debugger.h,v 1.7 2004/05/17 07:31:52 siramoto Exp $
 */


#ifndef H_DEBUGGER
#define H_DEBUGGER

#include<iostream>
#include<string>
#include<vector>

using namespace std;

#include"Input_position.h"

class Debugger {
private:
	Debugger(const Debugger& src);
	Debugger& operator=(const Debugger& src);
protected:
	bool	debug_mode;
	bool	step_mode;
	bool	stopped;
	bool	result_output_enable;
	int	debug_level;
	struct debug_element {
		Input_position	position;
		string	description;
		bool	is_expanded;
		bool	is_released;
		bool	is_sub;
		debug_element(Input_position p, string d, bool e,
			      bool r, bool s)
		  :position(p), description(d), is_expanded(e),
		   is_released(r), is_sub(s)
		{}
	};
	vector<debug_element>	debug_stack;
	vector<bool>	result_output_enable_stack;
	void inquire();
	void inquire_put_file(int level);
	void inquire_put_position(int level);
public:
	Debugger(bool is_debug_mode);
	void in(const Input_position& position, const string& description);
	void in_noninteractive(const Input_position& position,
			       const string& description);
	void out(const string& result_msg);
	istream* out(istream* result);		// copy result if print it
	void out();
	void put_msg(const string& msg) const;
	void in_expanded(const Input_position& position,
			 const string& description);
	void out_expanded();
	void in_sub(const Input_position& position,
		    const string& description);
	string stack_trace() const;
	void put(const string& result) const;
	void clean_released();
	void error();
};



#endif // H_DEBUGGER
