/*
 * Copyright (c) 2004, SHIRAMOTO Takeyuki
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Macro_definition.cc,v 1.4 2004/05/17 07:31:52 siramoto Exp $
 */

#include<cassert>
#include<cstdlib>
#include<iostream>
#include<sstream>
#include<string>
#include<vector>


using namespace std;

#include"define.h"
#include"Macro_definition.h"
#include"global.h"

Macro_definition::Macro_definition()
:macro_type(STRING_MACRO),
 string_macro(""),
 c_function(NULL),
 param_num(0)
{}

Macro_definition::Macro_definition(int parameter_num, macro_function func)
:macro_type(C_FUNCTION),
 c_function(func),
 param_num(parameter_num),
 string_macro("")
{
}

Macro_definition::Macro_definition(int parameter_num, string def)
:macro_type(STRING_MACRO),
 c_function(NULL),
 param_num(parameter_num),
 string_macro(def)
{
}

istream*
Macro_definition::call(const vector<string>& param_list) const
{
	istream* result;
	switch (macro_type) {
	case C_FUNCTION:
		result = c_function(param_list);
		break;
	case STRING_MACRO:
		result = expand_string_macro(param_list);
		break;
	default:
		cerr << "inside system error" << endl;
		exit(EXIT_FAILURE);
	}
	return result;
}

int
Macro_definition::parameter_num() const
{
	return param_num;
}

istream*
Macro_definition::expand_string_macro(const vector<string>& param_list) const
{
	string expanded;
	string::const_iterator p = string_macro.begin();
	while (p != string_macro.end()) {
		if (*p == special_char.macro) {
			expanded += *p;
			p ++;
			assert(p != string_macro.end());
			expanded += *p;
		}
		else if (*p == special_char.param) {
			p ++;
			assert(p != string_macro.end());
			if (isdigit(*p) && *p != '0') {
				expanded += param_list[*p-'1'];
			} else {
				expanded += *p;
			}
		} else {
			expanded += *p;
		}
		p ++;
	}
	return new istringstream(expanded);
}


