/*
 * Copyright (c) 2004, SHIRAMOTO Takeyuki
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Macro_input.cc,v 1.8 2004/05/17 07:31:52 siramoto Exp $
 */

#include<algorithm>
#include<cassert>
#include<cctype>
#include<cstdlib>
#include<iostream>
#include<sstream>
#include<stack>
#include<string>
#include<vector>

using namespace std;

#include"define.h"
#include"Macro_input.h"
#include"Debugger.h"
#include"Token.h"
#include"global.h"
#include"Input_position.h"

Macro_input::Macro_input()
:current_char(0),
 current_name("empty"),
 current_row(0),
 current_column(0),
 current_is(new istringstream(""))
{
	current_pos = current_is->tellg();
}

void
Macro_input::push(istream *is, const string& name)
{
	if (! input_stack.empty()){
		input_t& i = input_stack.top();
		i.is->putback(current_char);
		i.column = current_column;
		i.row = current_row;
	}
	input_t v(is, name, 1, 1);
	input_stack.push(v);
	next_char();
}

Input_position
Macro_input::position() const
{
	Input_position position;
	position.name	= current_name;
	position.row	= current_row;
	position.column	= current_column;
	position.pos	= current_pos;
	position.is	= current_is;
	return position;
}

void
Macro_input::next_char()
{
	for (;;) {
		if (input_stack.empty()) {
			current_char = 0;
			current_name = "empty";
			current_row = current_column = 0;
			current_is = new istringstream("");
			current_pos = current_is->tellg();
			return;
		}
		char ch;
		input_t& i = input_stack.top();
		i.is->clear();
		current_pos = i.is->tellg();
		i.is->get(ch);
		if (i.is->good()) {
			current_name = i.name;
			current_row  = i.row;
			current_column = i.column;
			current_is = i.is;
			current_char = ch;
			i.column ++;
			if (current_char == '\n') {
				i.column = 1;
				i.row ++;
			}
			return;
		} else {
			current_char = ' ';	// not '\n'
			assert(! input_stack.empty());
			input_stack.pop();
			debugger->out_expanded();
		}
	}
}

bool
Macro_input::get_token_is_special_char() const
{
	return current_char == special_char.macro ||
	       current_char == special_char.param ||
	       current_char == special_char.open_brace ||
	       current_char == special_char.close_brace; 
}

string
Macro_input::get_token_group()
{
	int level = 0;
	string s;
	for (;;) {
		assert(level >= 0);
		if (current_char == special_char.close_brace) {
			if (level == 0){
				next_char();
				return s;
			} else {
				s += current_char;
				next_char();
				level --;
			}
		} else if (current_char == special_char.open_brace) {
			s+= current_char;
			next_char();
			level ++;
		} else if (current_char == special_char.macro) {
			s+= current_char;
			next_char();
			if (current_char == 0) {
				cerr << "unexpected end" << endl;
				debugger->error();
				/* NOTREACHED */
			} else if (current_char != special_char.module &&
				   current_char != '_' &&
				   ! (current_char & 0x80) &&
				   ! isalnum(current_char))
			{
				s += current_char;
				next_char();
			} else {
				s += get_token_macro();
			}
		} else if (current_char == special_char.param) {
			s += current_char;
			next_char();
			if (current_char == 0) {
				cerr << "unexpected end" << endl;
				debugger->error();
				/* NOTREACHED */
			}
			s += current_char;
			next_char();
		} else if (current_char == 0) {
			cerr << "unexpected end" << endl;
			debugger->error();
			/* NOTREACHED */
		} else {
			s += current_char;
			next_char();
		}
	}
	/* NOTREACHED */
}


string
Macro_input::get_token_macro()
{
	ostringstream s;
	if (current_char != special_char.module)
		s << current_module << special_char.module;
	while (isalnum(current_char) ||
	       current_char == special_char.module ||
	       current_char & 0x80 ||
	       current_char == '_' )
       {
		s << current_char;
		next_char();
	}
	return s.str();
}


Token
Macro_input::get_token()
{
	string s;
	if (current_char == special_char.macro) {
		s = current_char;
		next_char();
		if (current_char == 0) {
			cerr << "unexpected end" << endl;
			debugger->error();
			/* NOTREACHED */
		} else if (current_char != special_char.module &&
			   current_char != '_' &&
			   ! (current_char & 0x80) &&
			   ! isalnum(current_char))
		{
			s += current_char;
			next_char();
			return Token(s, Token::STRING);
		} else {
			s = get_token_macro();
			return Token(s, Token::MACRO);
		}
		/* NOTREADED */
	} else if (current_char == special_char.param) {
		s = current_char;
		next_char();
		if (current_char == 0) {
			cerr << "unexpected end" << endl;
			debugger->error();
			/* NOTREACHED */
		}
		if (get_token_is_special_char()) {
			s += current_char;
			next_char();
		}
		return Token(s, Token::STRING);
	} else if (current_char == special_char.open_brace) {
		next_char();
		s = get_token_group();
		return Token(s, Token::STRING);
	} else if (current_char == special_char.close_brace) {
		cerr << "unexpected close brace" << endl;
		debugger->error();
		/* NOTREACHED */
	} else if (current_char == 0) {
		return Token(s, Token::END);
	} else {
		s = current_char;
		next_char();
		return Token(s, Token::STRING);
	}
	/* NOTREACHED */
}


void
Macro_input::skip_spaces()
{
	while (isspace(current_char))
		next_char();
}

