/*
 * Copyright (c) 2004, SHIRAMOTO Takeyuki
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Macro_input.h,v 1.5 2004/05/17 07:31:52 siramoto Exp $
 */


#ifndef H_MACRO_INPUT
#define H_MACRO_INPUT

#include<string>

using namespace std;

#include"Token.h"
#include"Input_position.h"

class Macro_input {
private:
	Macro_input(const Macro_input& src);
	Macro_input& operator=(const Macro_input& src);
protected:
	struct input_t {
		istream*	is;
		string		name;
		int		row;
		int		column;
		input_t()
		  :is(NULL), name(""), row(1), column(1) {}
		input_t(istream* is, string name, int row, int column)
		  :is(is), name(name), row(row), column(column) {}
	};
	stack<input_t>	input_stack;
	string		current_name;
	int		current_row;
	int		current_column;
	char		current_char;
	streampos	current_pos;
	istream*	current_is;

	void next_char();
	bool get_token_is_special_char() const;
	string get_token_group();
	string get_token_macro();

public:
	Macro_input();
	void push(istream *is, const string& name);
	Input_position position() const;
	Token get_token();
	void skip_spaces();
};

#endif // H_MACRO_INPUT
