/*
 * Copyright (c) 2004, SHIRAMOTO Takeyuki
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Macro_set.cc,v 1.6 2004/05/17 07:31:52 siramoto Exp $
 */

#include<map>
#include<string>
#include<vector>

using namespace std;

#include"Debugger.h"
#include"global.h"
#include"Macro_set.h"
#include"Macro_definition.h"

Macro_set::Macro_set()
{
	definition.push_back(def_map_t());
}


void
Macro_set::scope_in()
{
	definition.push_back(def_map_t());
}

void
Macro_set::scope_out()
{
	if (definition.size() <= 1) {
		cerr << "already in toplevel scope" << endl;
		debugger->error();
		/* NOTREACHED */
	}
	definition.pop_back();
}

void
Macro_set::define(const string& name, const Macro_definition& m)
{
	map<string,Macro_definition>::iterator p;
	p = definition.back().find(name);
	if (p != definition.back().end())
		definition.back().erase(p);
	definition.back().insert(make_pair(name,m));
}

void
Macro_set::global_define(const string& name, const Macro_definition& m)
{
	map<string,Macro_definition>::iterator p;
	p = definition.front().find(name);
	if (p != definition.front().end())
		definition.front().erase(p);
	definition.front().insert(make_pair(name,m));
}



Macro_definition
Macro_set::get_definition(const string& name) const
{
	def_map_t::const_iterator p;
	for (vector<def_map_t>::const_reverse_iterator q = definition.rbegin();
	     q != definition.rend();
	     q ++)
	{
		p = q->find(name);
		if (p != q->end())
			return p->second;
	}
	cerr << "macro " << name << " is not defined" << endl;
	debugger->error();
	/* NOTREACHED */
}

void
Macro_set::undefine(const string& name)
{
	def_map_t::iterator p;
	for (vector<def_map_t>::reverse_iterator q = definition.rbegin();
	     q != definition.rend();
	     q ++)
	{
		p = q->find(name);
		if (p != q->end()) {
			q->erase(p);
			break;
		}
	}
}

bool
Macro_set::is_defined(const string& name) const
{
	def_map_t::const_iterator p;
	for (vector<def_map_t>::const_reverse_iterator q = definition.rbegin();
	     q != definition.rend();
	     q ++)
	{
		p = q->find(name);
		if (p != q->end())
			return true;
	}
	return false;
}
