/*
 * Copyright (c) 2004, SHIRAMOTO Takeyuki
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in 
 *     the documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Macro_set.h,v 1.5 2004/05/17 07:31:52 siramoto Exp $
 */


#ifndef H_MACRO_SET
#define H_MACRO_SET

#include<map>
#include<string>
#include<vector>

using namespace std;

#include"Macro_definition.h"

class Macro_set {
private:
	Macro_set(const Macro_set&);
	Macro_set& operator=(const Macro_set&);
protected:
	typedef map<string, Macro_definition> def_map_t;
	vector<def_map_t> definition;
public:
	Macro_set();
	void scope_in();
	void scope_out();
	void define(const string& name, const Macro_definition& def);
	void global_define(const string& name, const Macro_definition& def);
	Macro_definition get_definition(const string& name) const;
	bool is_defined(const string& name) const;
	void undefine(const string& name);
};



#endif // H_MACRO_SET
