/*** SIGNAL.C ***/						#include	"main.h"

/*----------------------------------------------------------------------------------------------*/
/*** メモ：シグナル処理の流れ [御主人様の視点] ***/
/*----------------------------------------------------------------------------------------------*/
//（１）シグナルハンドラの定義と登録
//・事前に、{引数を１つか２つ取る}ユーザー関数 Func() を定義しておきませす。
//・システム関数 rxsig(SigNo,&Func()) で、そのユーザー関数をハンドラ登録します。
//・ここで SigNo は処理したいシグナル番号(整数)です。
//
//（２）シグナルハンドラの実行
//・SigNo 番のシグナルを受信したら、登録されたユーザー関数が自動で割り込み実行されます。
//・ユーザー関数の引数は SigNo{受信番号} と SigCt{受信回数} となります。(整数と整数)
//・ユーザー関数の終了後に、割り込まれたスクリプト本体が再開されます。
// {シグナルハンドラの実行後も、シグナルハンドラの登録状態は変化しません。}

/*----------------------------------------------------------------------------------------------*/
/*** メモ：シグナル処理の流れ [メイド猫の視点] ***/
/*----------------------------------------------------------------------------------------------*/
//（１）登録
//・SIG_DFL|SIG_IGN の場合、sig_vect[SigNo]=00 とし、OSに SIG_DFL|SIG_IGN を登録します。
//・&Func()         の場合、sig_vect[SigNo]=FX とし、OSに rt_handler()    を登録します。
//
//（２）実行
//・SIG_DFL|SIG_IGN の場合、シグナル受信時の実行処理はOSに任せます。
//・&Func()         の場合、シグナル受信時は rt_handler() が割り込みフラグを設定します。
//・そして exe_tlvlstmt() が次文の実行直前に cu_handler() 経由で Func() を実行します。
// {実行フレームのセーブ＆リストアは cu_handler() が行います。}

/************************************************************************************************/
// Rt_Handler() は、(ユーザー関数が登録されている)シグナル番号を受信した場合に、OSから非同期で起動
// されます。受信したシグナル番号を外部変数に記録保存することが唯一の仕事です。
/************************************************************************************************/
void rt_handler(int signal_no){			// RealTime Signal Handler
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

	sig_iall++; sig_tall++; sig_icnt[signal_no]++; sig_tcnt[signal_no]++;	/*** !!! This must finish ASAP !!! ***/

}

/************************************************************************************************/
// Cu_Handler() は、登録済みのユーザー関数を割り込み実行します。割り込み実行と復帰再開に必要な実行
// フレームのセーブ＆リストアもこの関数で行います。
/************************************************************************************************/
void cu_handler(void){					// Call (UsrDef)Func() Signal Handler
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

ctree	*fctr, *fpar;	dtab	*elmt;
int		signo, sigct;					/* Signal Number | Signal Counter						*/
tint	addr;							/* (UsrDef)Func() Addr on MEM[]							*/

/* Disable Multi-Interupting */
	if( flag_signing ) return; else flag_signing=TRUE;

/* Set SigNo|SigCt & Adjust Cntr */
	for( signo=0 ; signo<NSIG ; signo++ ){ if( sig_icnt[signo]!=0 ) break; }
	sigct = sig_tcnt[signo];

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_SIGNO ){
		eprin("[%sSg%s] Signal %02d Detected!! [Iall=%d,Tall=%d,Icnt=%d,Tcnt=%d]\n",
		C_MAG(2), C_DEF(2), signo, sig_iall, sig_tall, sig_icnt[signo], sig_tcnt[signo]);
	}

	sig_iall       --;					// Adjust must be done before X_CALL()!!
	sig_icnt[signo]--;					// Adjust must be done before X_CALL()!!

/* Set (UsrDef)Func() & Param(s) */
	addr = (tint)sig_vect[signo];
	fctr = mem[addr+FX_TREE];			// CTREE for (UsrDef)Func()

	fpar = ext_ctrdtabmult(NULL,2);		// CTREE for Param(s)   *** New!! ***
	elmt = ctr2p_dtab( lptr(fpar,0) ); elmt->type='I'; elmt->ival=signo;	/* {受信番号} */
	elmt = ctr2p_dtab( lptr(fpar,1) ); elmt->type='I'; elmt->ival=sigct;	/* {受信回数} */

	fctr->r = fpar;						// Connect!!

/* Call (UsrDef)Func() & Return */
	x_call(fctr,FALS);					/*** TT-Lang: A = F(...) [ L=FNAM,R=PARAM,X=STMT ] ***/
	flag_signing=FALS; return;

}
