/*** X_RENE.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_rene(ctree *ptr){				/*** TT-Lang: A = X~~Y | X!~Y ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/

int		op = (ptr==NULL?0x00:ptr->op);
ctree	*ans;	dtab	*a,*x,*y;
int		flag_x,flag_y;					/* Flag for /RE/ (T/F)									*/
char	*plain;							/* Pointer to Plain Side String							*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
regex_t		*p_preg;					/* /RE/ Compiled Pattern Buffer							*/
regmatch_t	pmatch;						/* /RE/ Substring Address Info Buffer					*/
int			errcode;					/* /RE/ Error Code										*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* Debug & PreCheck */
	chk_point(ptr);

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( eva_expr(ptr->l,1) ); chk_error(ptr); chk_vtype(x,"S",0);	/* L=>0 */
	y = ctr2p_dtab( eva_expr(ptr->r,1) ); chk_error(ptr); chk_vtype(y,"S",1);	/* R=>1 */

/* Check /RE/ vs /RE/ */
	flag_x = isreg(x);
	flag_y = isreg(y);
	if( flag_x==flag_y ){
		if( op==REQ ){ a = ctr2p_dtab( ans=ext_ctrdtab(ptr) ); a->type='I'; a->ival=FALS; return ans; }
		if( op==RNE ){ a = ctr2p_dtab( ans=ext_ctrdtab(ptr) ); a->type='I'; a->ival=TRUE; return ans; }
		if( op==RAT ){ ans = ext_ctrdtabmult(ptr,2);
			a = ctr2p_dtab(lptr(ans,0)); null_dtab(a);
			a = ctr2p_dtab(lptr(ans,1)); null_dtab(a);
			return ans;
		}
	}

/* Set Compiled RE Pattern & Target-String */
	if( flag_x==TRUE ){					/*** /RE/ OP 'S'  ***/
		if( x->ptr2==NULL )				// >Don't Have Compiled RE Pattern ?
			regcc(x);					// >Compile & Save /RE/
		p_preg = x->ptr2;
		plain  = y->str;
	}
	else{								/*** 'S'  OP /RE/ ***/
		if( y->ptr2==NULL )				// >Don't Have Compiled RE Pattern ?
			regcc(y);					// >Compile & Save RE
		p_preg = y->ptr2;
		plain  = x->str;
	}

/* Do REQ()!! */
	if( op==REQ ){ errcode = regexec(p_preg,plain,1,&pmatch,0);
		a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
		a->type = 'I'; a->ival = (errcode==0)?TRUE:FALS;
		return ans;
	}

/* Do RNE()!! */
	if( op==RNE ){ errcode = regexec(p_preg,plain,1,&pmatch,0);
		a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );
		a->type = 'I'; a->ival = (errcode!=0)?TRUE:FALS;
		return ans;
	}

/* Do RAT()!! - Return Matched Position(Star&End) or NULL(Null&Null) */
	if( op==RAT ){ errcode = regexec(p_preg,plain,1,&pmatch,0);
		ans = ext_ctrdtabmult(ptr,2);
		if( errcode==0 ){				// Matched !!	//
			a = ctr2p_dtab(lptr(ans,0)); a->type='I'; a->ival = (tint)(pmatch.rm_so);
			a = ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival = (tint)(pmatch.rm_eo);
		}
		else{							// NoMatch !!	//
			a = ctr2p_dtab(lptr(ans,0)); null_dtab(a);
			a = ctr2p_dtab(lptr(ans,1)); null_dtab(a);
		}
		return ans;
	}

/* Assert!! */
	return NULL;

}
