/*** X_UNOP.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_unop(ctree *ptr){				/*** TT-Lang: A = +X | -X | &X ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/

int		op = (ptr==NULL?0x00:ptr->op);
ctree	*ans;	dtab	*a,*x;

/* Debug & PreCheck */
	chk_point(ptr);

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( eva_expr(ptr->r,1) ); chk_error(ptr);
	if( op=='+'||op=='-' ){ chk_vtype(x,"IDP",0); }else{ chk_vtype(x,"*",0); }
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Do POS()!! */
	if( op=='+' ){
		if( isiptr(x)    ){ a->type = 'I'; a->ival = +cint(x); return ans; }
		if( x->type=='D' ){ a->type = 'D'; a->dval = +cdbl(x); return ans; }
	}

/* Do NEG()!! */
	if( op=='-' ){
		if( isiptr(x)    ){ a->type = 'I'; a->ival = -cint(x); return ans; }
		if( x->type=='D' ){ a->type = 'D'; a->dval = -cdbl(x); return ans; }
	}

/* Do ADDR()!! */	// 原則として、DTAB X が保持しているデータ本体の先頭アドレスを返す。
	if( op=='&' ){
		if( x->type=='S' ){ a->type='P'; a->ptr= (x->str ); return ans; }	// 文字列の先頭アドレス
		if( x->type=='I' ){ a->type='P'; a->ptr=&(x->ival); return ans; }	// 整数値の先頭アドレス
		if( x->type=='D' ){ a->type='P'; a->ptr=&(x->dval); return ans; }	// 実数値の先頭アドレス
		if( x->type=='P' ){ a->type='P'; a->ptr= (x->ptr ); return ans; }	// ポインタ値 ( P=&P )
		if( x->type=='X' )				// 関数 DTAB 値そのもの
			{ cpy_dtab(a,x);								return ans; }
		if( x->type=='A' )				// 配列データの先頭アドレス
			{ a->type='P'; a->ptr = (x->ptr !=0) ? (x->ptr):(x->ptr2            );		return ans; }
		if( x->type=='R' )				// リファレンス先 1[Byte] データのアドレス
			{ a->type='P'; a->ptr = &( (x->str)[x->ival] );								return ans; }
	}

/* Assert!! */
	return NULL;

}

// ビット反転演算子 ~ の処理関数は、"X_BITS.C" に存在する。
// 論  理反転演算子 ! の処理関数は、"X_LGCL.C" に存在する。
