/*** I_RADDEG.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_rad2deg(ctree *ctr){			/*** TT-Lang: A = RAD2DEG(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do RAD2DEG()!! */
	a->type='D'; a->dval=cdbl(x)*180.0L/M_PIx; return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_deg2rad(ctree *ctr){			/*** TT-Lang: A = DEG2RAD(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do DEG2RAD()!! */
	a->type='D'; a->dval=cdbl(x)*M_PIx/180.0L; return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_xxx2dms(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
tdbl	d,m,s,r;		int		sign;	/* Degree / Minute / Second / Remainder / '+' or '-'	*/

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	ans = ext_ctrdtabmult(ctr,3);

/* Do XXX2DMS()!! */
	sign = (cdbl(x)>=0.0L) ? '+' : '-' ;
	if( mode=='R'){ r=fabs(cdbl(x))*180.0L/M_PIx; }			// -8.12345 -> +8.12345
	if( mode=='D'){ r=fabs(cdbl(x));              }			// -8.12345 -> +8.12345
	d=floor(r);							// +8.00000
	r=r-d;								// +0.12345
	m=floor(r*60.0L);					// +7
	r=r-m/60.0L;						// +0.00678333...
	s=r*3600.0L;						// +24.42

	a = ctr2p_dtab(lptr(ans,0)); a->type='I'; a->ival=(tint)(sign=='+'?+d:-d);	/*** Degree ***/
	a = ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival=(tint)(sign=='+'?+m:-m);	/*** Minute ***/
	a = ctr2p_dtab(lptr(ans,2)); a->type='D'; a->dval=(tdbl)(sign=='+'?+s:-s);	/*** Second ***/
	return ans;
}
ctree *i_rad2dms(ctree *ctr){ /*** TT-Lang: (A,B,C) = RAD2DMS(X) ***/ return do_xxx2dms(ctr,'R'); }
ctree *i_deg2dms(ctree *ctr){ /*** TT-Lang: (A,B,C) = DEG2DMS(X) ***/ return do_xxx2dms(ctr,'D'); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_dms2xxx(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y,*z;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(x,"ID",1);
	z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(x,"ID",2);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do DMS2XXX()!! */
	a->type='D';
	if( mode=='R'){ a->dval = (cdbl(x)+cdbl(y)/60.0L+cdbl(z)/3600.0L)*M_PIx/180.0L; }
	if( mode=='D'){ a->dval = (cdbl(x)+cdbl(y)/60.0L+cdbl(z)/3600.0L)             ; }
	return ans;
}
ctree *i_dms2rad(ctree *ctr){ /*** TT-Lang: A = DMS2RAD(X,Y,Z) ***/ return do_dms2xxx(ctr,'R'); }
ctree *i_dms2deg(ctree *ctr){ /*** TT-Lang: A = DMS2DEG(X,Y,Z) ***/ return do_dms2xxx(ctr,'D'); }
