/*** DUMP-MAIN.C ***/					#include	"main.h"

/************************************************************************************************/
// DUMP_CPU() dump CPU Regs.
/************************************************************************************************/
extern void dump_cpu(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	eprin("%s### CPU ###%s  MP=%04d / _B=%04d / DP=%04d / _B=%04d / RP=%04d / FX=%04d\n"\
		, W_BLU(2), W_DEF(2), mp, mp_base, dp, dp_base, rp, fx);
}

/************************************************************************************************/
// DUMP_MEM() dump MEM[]. ( MEM[0] - MEM[MP-1] )
/************************************************************************************************/
extern void dump_mem(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	for( int addr=0 ; addr<mp ; addr++ ){
	/* >Display Address */
		eprin("  MEM[%04d]: A=%p - ", addr, &mem[addr]);
	/* >Display Content */
		if( addr==0                                          ) eprin("%s", C_YEL(2));
		if( addr==GL_DTAB                                    ) eprin("%s", C_BLU(2));
		if( addr> GL_DTAB && (addr-GL_DTAB)%FX_UNIT==ST_DTAB ) eprin("%s", C_GRE(2));
		if( addr> GL_DTAB && (addr-GL_DTAB)%FX_UNIT==LC_DTAB ) eprin("%s", C_RED(2));

		if( (tint)mem[addr]==INVA ) eprin("D=0xFFFFFFFFFFFF "                   );
		else						eprin("D=0x%012"PRIxTINT" ", (tint)mem[addr]);

		if( (tint)mem[addr]<=9999 ){ eprin("(%4"PRIdTINT") - ", (tint)mem[addr]); } else{ eprin("(####) - "); }

		if( addr==0                                          ) eprin("{ ADMIN }"           );
		if( addr==GL_DTAB                                    ) eprin("GL_DTAB (\'G\'=0x47)");
		if( addr> GL_DTAB && (addr-GL_DTAB)%FX_UNIT==ST_DTAB ) eprin("ST_DTAB (\'S\'=0x53)");
		if( addr> GL_DTAB && (addr-GL_DTAB)%FX_UNIT==LC_DTAB ) eprin("LC_DTAB (\'L\'=0x4C)");
		if( addr> GL_DTAB && (addr-GL_DTAB)%FX_UNIT==FX_TREE ){
			ctree *p_ctr = mem[addr];
			eprin(">TREE - File = %s"  , (p_ctr==NULL                ) ? "N/A":fn(p_ctr->file));
		}
		if( addr> GL_DTAB && (addr-GL_DTAB)%FX_UNIT==FX_INFO ){
			dtab  *p_dtab = cdx2p_dtab( (tint)mem[addr] );		// (UsrDef)Func() - Normal
			if( p_dtab==NULL ) p_dtab=mem[addr];				// (UsrDef)Func() - Dupped
			if( (tint)mem[addr]==INVA ) eprin(">INFO - *** N/A ***"                                          );
			else						eprin(">INFO - Func = %s()", (p_dtab==NULL) ? "TopLevel":p_dtab->name);
		}
		eprin("%s\n", C_DEF(2));
	}
}

/************************************************************************************************/
// DUMP_ST() dump DS[]. ( DS[0] - DS[DP-1] )
/************************************************************************************************/
extern void dump_st(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	for( int addr=0 ; addr<dp ; addr++ ){
	/* >Display Address */
		eprin("  DS[%04d]: A=%p - ", addr, &ds[addr]);
	/* >Display Content */
		if( addr==0 ) eprin("%s", C_YEL(2));
		if( ds[addr].type!='A' ){ eprin("\'%c\' %s = %s",ds[addr].type,dn(&ds[addr]),dv(&ds[addr])); }
		else{ eprin("\'%c\' %s",ds[addr].type,dn(&ds[addr])); };
		if( addr==0 ) eprin("%s\n", C_DEF(2));
	}
}

/************************************************************************************************/
// DUMP_RT() dump RS[]. ( RS[0] - RS[RP-1] )
/************************************************************************************************/
extern void dump_rt(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	for( int addr=0 ; addr<rp ; addr++ ){
	/* >Display Address */
		eprin("  RS[%04d]: A=%p - ", addr, &rs[addr]);
	/* >Display Content */
		if( addr==0 ) eprin("%s", C_YEL(2));
		eprin("MP=%04d / _B=%04d / DP=%04d / _B=%04d / FX=%04d / PTR=%p"\
			, rs[addr].mp, rs[addr].mp_base, rs[addr].dp, rs[addr].dp_base, rs[addr].fx, rs[addr].ptr);
		eprin("%s%s\n", (addr==0) ? " - { ADMIN }":"", C_DEF(2));
	}
}

/************************************************************************************************/
// DUMP_FT() dump FileTb[]. ( FileTb[0] - FileTb[(FileTb[0].valid)-1] )
/************************************************************************************************/
extern void dump_ft(void){
	for( int idx=0 ; idx!=INVA ; idx=FileTb[idx].next ){
	/* >Display Address */
		eprin("  FileTb[%04d]: A=%p - ", idx, &FileTb[idx]);
	/* >Display Content */
		eprin("(alloc=%d,valid=%d)\n", FileTb[idx].alloc, FileTb[idx].valid);
		eprin("  >path =%s\n"  , FileTb[idx].path);
		eprin("  >name =%s\n"  , FileTb[idx].name);
		eprin("  >linv =%p\n"  , FileTb[idx].linv);
		eprin("  >ybuf =%p\n"  , FileTb[idx].ybuf);
		eprin("  >ylin =%d\n"  , FileTb[idx].ylin);
		eprin("  >mode =\'%c\'(next=%d,prev =%d)\n", FileTb[idx].mode, FileTb[idx].next, FileTb[idx].prev);
	}
}

/************************************************************************************************/
// DUMP_DT() dump N DTABs in {GL_DTAB|LC_DTAB|ST_DTAB} on MEM[] if PARAM is MEM[] address,
//   or dump 1 DTAB if PARAM is (DTAB*) Address.
/************************************************************************************************/
extern void dump_dt(tint param){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		flag_direct=FALS,addr;			dtab	*p_dtab;
/* Check & Convert Address */
	if( (tint)mem[0]<param ){			// Current MEM[] Size
		flag_direct=TRUE;
		p_dtab=(dtab *)param;
	}
	else{
		p_dtab=(dtab *)mem[addr=(int)param];
		if( (addr==GL_DTAB) || (addr-GL_DTAB)%FX_UNIT==ST_DTAB || (addr-GL_DTAB)%FX_UNIT==LC_DTAB )
			;
		else              { eprin("( NOT DTAB )\n"); return; }
	}
	if( p_dtab==NULL ){ eprin("*** NULL ***\n"); return; }
/* Dump 1 DTAB */
	if( flag_direct ){
		eprin("  %s=%s\n",dn(p_dtab),dv(p_dtab)); return;
	}
/* Dump N DTABs in XX_DTAB ( XX_DTAB[0] - XX_DTAB[(XX_DTAB[0].IVAL)] ) */
	for( int idx=0 ; idx<=p_dtab[0].ival ; idx++ ){
	/* >Display Address */
		if( addr==GL_DTAB                                    ) eprin("  %s%s", C_BLU(2), "GL");
		if( addr >GL_DTAB && (addr-GL_DTAB)%FX_UNIT==ST_DTAB ) eprin("  %s%s", C_GRE(2), "ST");
		if( addr >GL_DTAB && (addr-GL_DTAB)%FX_UNIT==LC_DTAB ) eprin("  %s%s", C_RED(2), "LC");
		eprin("_DTAB[%04d]:%s A=%p - ", idx, C_DEF(2), &p_dtab[idx]);
	/* >Display Content */
		if( idx==0 ) eprin("%s", C_YEL(2));
		if( p_dtab[idx].type!='A' ){
			eprin("\'%c\' %s = %s",p_dtab[idx].type,dn(&p_dtab[idx]),dv(&p_dtab[idx]));
			if( p_dtab[idx].type=='X' )
				eprin(" Attr=0x%X/Ival=%"PRIdTINT"/Ptr=0x%p",p_dtab[idx].attr,p_dtab[idx].ival,p_dtab[idx].ptr);
		}
		else{ eprin("\'%c\' %s",p_dtab[idx].type,dn(&p_dtab[idx])); }
		eprin("%s\n",C_DEF(2));
	}
}

/************************************************************************************************/
// DUMP_CT() dump CTREE structure for V_TMP or MEM[V_TMP]. DEPTH = Indent Level. (0,1,2,3 ... )
/************************************************************************************************/
void dump_ct(tint v_tmp,int depth){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		f_ptr;		ctree	*p_ctr;		dtab	*a;
/* Check & Convert Address */
	if( (tint)mem[0]<v_tmp ){			// MEM[0] = Current MEM[] Size
		f_ptr=TRUE;
		p_ctr=(ctree *)v_tmp;
	}
	else{
		f_ptr=FALS;
		p_ctr=mem[(int)v_tmp];
	}
/* Dump NULL */
	if( p_ctr==NULL ){ indent(depth); eprin("** CTREE <NULL> **\n"); return; }

/* Dump CTREE */
	indent(depth); eprin("[%p] OP=",p_ctr);
	switch(p_ctr->op){
		case SYNC:  eprin("SYNC"); break; case LINK:  eprin("LINK"); break; case FCAL:  eprin("FCAL"); break;
		case PRIN:  eprin("PRIN"); break; case ARRY:  eprin("ARRY"); break; case HASH:  eprin("HASH"); break;
		case STID:  eprin("STID"); break;
		case INAM:  eprin("INAM"); break; case IMED:  eprin("IMED"); break; case BKQT:  eprin("BKQT"); break;

		case GLKW:  eprin("GLKW"); break; case STKW:  eprin("STKW"); break; case LCKW:  eprin("LCKW"); break;
		case DEFX:  eprin("DEFX"); break;
		case IF:    eprin("IF  "); break; case ELIF:  eprin("ELIF"); break; case ELSE:  eprin("ELSE"); break;
		case SWCH:  eprin("SWCH"); break; case CASE:  eprin("CASE"); break; case DEFT:  eprin("DEFT"); break;
		case FORS:  eprin("FORS"); break; case WHIL:  eprin("WHIL"); break; case DOWH:  eprin("DOWH"); break;
		case EACH:  eprin("EACH"); break; case LOOP:  eprin("LOOP"); break;
		case NEXT:  eprin("NEXT"); break; case LAST:  eprin("LAST"); break; case RETN:  eprin("RETN"); break;

		case POW:   eprin("POW "); break; case SOP:   eprin("SOP "); break; case VOP:   eprin("VOP "); break;
		case VPP:   eprin("VPP "); break; case VMM:   eprin("VMM "); break;
		case SLL:   eprin("SLL "); break; case SRR:   eprin("SRR "); break; case PTR:   eprin("PTR "); break;
		case CGE:   eprin("CGE "); break; case CLE:   eprin("CLE "); break;
		case CEQ:   eprin("CEQ "); break; case CNE:   eprin("CNE "); break;
		case REQ:   eprin("REQ "); break; case RNE:   eprin("RNE "); break;

		case ADDQ:  eprin("ADDQ"); break; case SUBQ:  eprin("SUBQ"); break; case MULQ:  eprin("MULQ"); break;
		case DIVQ:  eprin("DIVQ"); break; case MODQ:  eprin("MODQ"); break; case POWQ:  eprin("POWQ"); break;
		case ANDQ:  eprin("ANDQ"); break; case IORQ:  eprin("IORQ"); break; case XORQ:  eprin("XORQ"); break;
		case SLLQ:  eprin("SLLQ"); break; case SRRQ:  eprin("SRRQ"); break;
		case LAND:  eprin("LAND"); break; case LIOR:  eprin("LIOR"); break; case LXOR:  eprin("LXOR"); break;
		case UNARY: eprin("UNRY"); break;
		case 0x00:  eprin("LEAF(Normal)"); break; case 0xFF:  eprin("leaf(Direct)"); break;
		default: eprin("\'%c\'(0x%02X)",p_ctr->op,p_ctr->op);
	}
	eprin(" (File=%d,Line=%d,Colm=%d) L=%p R=%p X=%p", p_ctr->file, p_ctr->line, p_ctr->colm, p_ctr->l, p_ctr->r, p_ctr->x);
/* Dump <GAP>&CLEAF */
	if( p_ctr->op==0x00||p_ctr->op==0xFF ){
		if( p_ctr->x==NULL ){ eprin(" %s<GAP>%s\n", C_YEL(2), C_DEF(2)); }
		if( p_ctr->x!=NULL ){ eprin(" : "); a=ctr2p_orig(p_ctr);
			eprin("\'%c\' %s\n",a->type,dn(a));		/*** See X_ASGN()!! ***/
		}
		return;
	}
	eprin("\n");
/* Dump RECUR */
	if( p_ctr->l!=NULL ){ indent(depth); eprin("<Left>\n"); dump_ct((tint)(p_ctr->l),depth+1); }
	if( p_ctr->r!=NULL ){ indent(depth); eprin("<Righ>\n"); dump_ct((tint)(p_ctr->r),depth+1); }
	if( p_ctr->x!=NULL ){ indent(depth); eprin("<Xtra>\n"); dump_ct((tint)(p_ctr->x),depth+1); }
}

/************************************************************************************************/
// STRACE() displays "<File=###,Line=###> TT-Script" info for "-t" mode.
// Note: Check JTRACE()/X_ASGN()/X_CALL()/X_PPMM() also, because they have own STRACE() code.
/************************************************************************************************/
extern void strace(ctree *ptr){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	**linv;
/* Print Trace Info ( if required & if applicable ) -- Skip Same Line -- */
	if( flag_trace && (ptr->line)!=0 && (tr_file!=(ptr->file)||tr_line!=(ptr->line)) ){
	/* >Renew Info */
		tr_file = (ptr->file);			// ( ファイル番号の更新 )
		tr_line = (ptr->line);			// ( 行番号の更新 )
		linv = fv(tr_file);				// ( 行情報の設定 )
		if( linv==NULL ) return;
	/* >Print Info */
		if( ptr->op==SYNC && X_EXPN(linv[tr_line-1],4)==NULL )
			eprin("*** %sEOF%s ***\n",C_RED(2),C_DEF(2));
		else
			eprin("%s<File=%s,Line=%03d>%s %s", C_YEL(2), fn(tr_file), tr_line, C_DEF(2), X_EXPN(linv[tr_line-1],4));
	}
}
/************************************************************************************************/
// JTRACE() displays "Judgement Result" info for "-t" mode. ( if/for/while/... )
/************************************************************************************************/
extern void jtrace(char *fname,int jv,char *t_str,char *f_str){
	if( flag_trace )
		eprin("%s(%s%s%s)\n",fname,C_RED(1),jv?t_str:f_str,C_DEF(1));
}
