/*** ESCDOL.C ***/						#include	"main.h"

/************************************************************************************************/
// EVALESC() translate ESC Seq into Ctrl Char, then return translated String. [ X_SDUP()ed ]
/************************************************************************************************/
char *evalesc(char *orig){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*eval=NULL;						/* Evaled (Translated) String							*/
char	buf[BUFSIZ];					/* Buffer for "\xFF"									*/
int		flag_esc=FALS, len, s, d;

/* NULL Check */
	if( orig==NULL ) return NULL;
/* Translate Orig into Eval */
	len =strlen2(orig);
	eval=X_ATOM(len+1);
	for( s=0,d=0 ; s<len ; s++ ){				// For all Chars in Orig
	/*** Nominal State ***/
		if( flag_esc==FALS ){
			if( orig[s]=='\\' ){ flag_esc=TRUE; continue; }		/*** Escape In	***/
			eval[d++] = orig[s];								/*** (  Copy  )	***/
		}
	/*** Escaped State ***/
		else{
			flag_esc=FALS;										/*** Escape Out	***/
			switch( orig[s] ){									/*** (  Copy  )	***/
				case '0': eval[d++]='\0'; break; case 'a': eval[d++]='\a'; break;
				case 'b': eval[d++]='\b'; break; case 't': eval[d++]='\t'; break;
				case 'n': eval[d++]='\n'; break; case 'v': eval[d++]='\v'; break;
				case 'f': eval[d++]='\f'; break; case 'r': eval[d++]='\r'; break;
				case 'e': eval[d++]=0x1B; break;
				case 'x':
						if( s+2<len ){
							buf[0] = orig[s+1];
							buf[1] = orig[s+2];
							buf[2] = '\0';
							eval[d++] = strtol(buf,NULL,16); s += 2;
						}
						else{
							eval[d++] = '?';                 s = len-1;
						}
				default:  eval[d++]=orig[s];
			}
		}
	}
/* Term & Return */
	if( flag_esc==TRUE ){ eval[d++]='\\'; }		// Last Char is ESC
	eval[d++]='\0';
	return X_RALL(eval,d);				/* This will include '\0' in Eval						*/
}

/************************************************************************************************/
// RVALESC() translate Ctrl Char into ESC Seq, then return translated String. [ X_SDUP()ed ]
/************************************************************************************************/
char *rvalesc(char *orig){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*rval;							/* Rvaled (Translated) String							*/
int		len, s, d;

/* NULL Check */
	if( orig==NULL ) return NULL;
/* Translate Orig into Rval */
	len =0;
	rval=X_ATOM(len+1);
	for( s=0,d=0 ; orig[s]!='\0' ; s++ ){		// For all Chars in ORIG
	/*** Nominal Char or Kanji Char ***/
		if( isprint(orig[s]) || (orig[s]&0x80) ){
			len++; rval=X_RALL(rval,len+1);
			rval[d++] = orig[s];								/*** (  Copy  )	***/
		}
	/*** Control Char ***/
		else if( orig[s]=='\0' || orig[s]=='\a' || orig[s]=='\b' || orig[s]=='\t' || orig[s]=='\n' \
			  || orig[s]=='\v' || orig[s]=='\f' || orig[s]=='\r' || orig[s]==0x1B                  ){
			len+=2; rval=X_RALL(rval,len+1);
			switch( orig[s] ){									/*** (  Copy  )	***/
				case '\0': rval[d++]='\\'; rval[d++]='0'; break;
				case '\a': rval[d++]='\\'; rval[d++]='a'; break;
				case '\b': rval[d++]='\\'; rval[d++]='b'; break;
				case '\t': rval[d++]='\\'; rval[d++]='t'; break;
				case '\n': rval[d++]='\\'; rval[d++]='n'; break;
				case '\v': rval[d++]='\\'; rval[d++]='v'; break;
				case '\f': rval[d++]='\\'; rval[d++]='f'; break;
				case '\r': rval[d++]='\\'; rval[d++]='r'; break;
				case 0x1B: rval[d++]='\\'; rval[d++]='e'; break;
			}
		}
	/*** "\xFF" Char ***/
		else{
			len+=4; rval=X_RALL(rval,len+1);
			rval[d++]='\\';										/*** (  Copy  )	***/
			rval[d++]='x';
			sprintf(&rval[d++],"%02X",orig[s]); d++;
		}
	}
/* Term & Return */
	rval[d++]='\0';
	return rval;
}

/************************************************************************************************/
// EVALDOL() evaluates "${...}" sequence in string (ORIG).  Then returns evaluated string.
/************************************************************************************************/
char *evaldol(char *orig){				/*** IF NOT REPLACED, ORIG POINTER WILL BE RETURNED!! ***/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	buf[BUFSIZ], *eval=NULL;		/* Temporary Buffer | Evaluated String					*/
char	*pn=orig, *ps, *pe;				/* Pointer to "${...}" ( See Below )					*/
ctree	*p_ctr;			dtab	*p_dtb;
int		flag_replaced=FALS;

// ORIG = ".... $ { .... } ...."\0
//         N    S        E

/* Check "${...}" Pattern */
	while( chk_evaldol(pn,&ps,&pe)==TRUE ){

// Note: EVALDOL() evaluation should be done at current local frame!!
// 1) GL_DTAB/ST_DTAB/LC_DTAB should be shared with intended sideeffects.
// 2) CTR & CDX on MEM[] should not be shared. ( Isolate iCODE body for EVALDOL(). )

	/*** ( Push&Init Env ) ***/
		savchg_f4yy('$',X_NDUP(ps,pe-ps+1));

		rp+=3; chk_overflow(); rp-=3;
		rs[rp++].ptr =mem[mp_base+FX_TREE];
		rs[rp++].ptr =mem[mp_base+FX_INFO];
		rs[rp++].mode=flag_imode;

	/*** ( Eval ${...} => Result is on MEM[] ) ***/
		flag_imode='$'; yyparse();
		p_ctr = eva_expr((ctree *)mem[mp_base+FX_TREE],0);	// Ignore nested "${...}" here.
		p_dtb = ctr2p_dtab(p_ctr);							// *** Result ***

	/*** ( Pop  &Rstr Env ) ***/
		flag_imode          =rs[--rp].mode;
		mem[mp_base+FX_INFO]=rs[--rp].ptr;
		mem[mp_base+FX_TREE]=rs[--rp].ptr;

		reschg_f4yy();

	/*** ( Make String ) ***/
		if( p_dtb==NULL || (p_dtb!=NULL&&p_dtb->type=='U') )// Copy AsIsed String ( Not Found || UnDefined )
			eval=X_NCAT(eval,pn,pe-pn+1);
		else{												// Subs Evaled String ( in String )
		/* > Copy ( pn -> ps-1 ) */
			eval=X_NCAT(eval,pn,ps-pn+0);
		/* > Copy ( ps -> pe   ) */
			switch( p_dtb->type ){
				case 'S': flag_replaced=TRUE; sprintf(buf,FMT_S2S(),p_dtb->str ); eval=X_SCAT(eval,buf); break;
				case 'I': flag_replaced=TRUE; sprintf(buf,FMT_I2S(),p_dtb->ival); eval=X_SCAT(eval,buf); break;
				case 'D': flag_replaced=TRUE; sprintf(buf,FMT_D2S(),p_dtb->dval); eval=X_SCAT(eval,buf); break;
				case 'P': flag_replaced=TRUE;
					sprintf(buf, isnull(p_dtb)?FMT_N2S():FMT_P2S() ,p_dtb->ptr ); eval=X_SCAT(eval,buf); break;
				default : eval=X_NCAT(eval,ps,pe-ps+1); /* Copy AsIsed String */
			}
		}
	/*** ( Proceed to Next ) ***/
		pn=pe+1;
	}

/* Copy ( pn -> '\0' ) */
	eval=X_SCAT(eval,pn);
	return( flag_replaced ? eval:orig );
}

/************************************************************************************************/
// CHK_EVALDOL() checks "${" and "}" pattern in string (STR), and set their positions into ret_s
// & ret_e.  ( NULL will disable this setting. )  Then returns result (TRUE/FALS).
/************************************************************************************************/
int chk_evaldol(char *str,char **ret_s,char **ret_e){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*ptr_s=NULL, *ptr_e=NULL;
int		flag_esc=FALS, depth=0;

// STR = "... $ { ... } ..."\0
//            S       E

// '/' の次は１文字エスケープするので…
// (1) "/${" や "$/{" は "${...}" の開始記号とはなりません。
// (2) "${" 後の "/}" は "${...}" の終了記号とはなりません。

/* Check "${" and "}" pattern */
	for( int idx=0 ; str[idx]!='\0' ; idx++ ){
		if( flag_esc==FALS ){
			if( str[idx]=='\\'                   ){ flag_esc=TRUE; continue; }
			if( str[idx]=='$' && str[idx+1]=='{' ){ ptr_s = (ptr_s==NULL) ? &str[idx]:ptr_s; idx++; depth++; }
			if( str[idx]=='}' && 0<depth         ){ ptr_e = (depth==   1) ? &str[idx]:NULL ;        depth--; }
		}
		else                                      { flag_esc=FALS; continue; }
		if( ptr_s!=NULL && ptr_e!=NULL ) break;
	}
/* Assign & Return */
	if( ptr_s!=NULL && ptr_e!=NULL ){
		if( ret_s!=NULL ) *ret_s=ptr_s;		/*** RET_S==NULL Disable Assignment !! ***/
		if( ret_e!=NULL ) *ret_e=ptr_e;		/*** RET_E==NULL Disable Assignment !! ***/
		return(TRUE);
	}
	else
		return(FALS);
}
