/*** X_SHQT.C ***/                      #include    "main.h"

#define		P_RD		0				/* for pipe(2)											*/
#define		P_WR		1				/* for pipe(2)											*/

// ★文字列を外部コマンドとして実行し… ( ×標準入力無し | ○画面出力有り )
// > ! STR              -> Shell [!種] を連続実行する。{ ****** | ○out   | ○err | 戻り値 $? }
// > % STR              -> Shell [%種] を連続実行する。{ put(%) | get(%) | ○err | 戻り値 $? }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_shqt(ctree *ptr){				/*** TT-Lang: ! X | % X ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/

ctree	*ans;			dtab	*a,*x,*y/*,*dq*/;				/*** DQ => $? ***/
int		mode;

static FILE	*fp_i,*fp_o;				/* [STATIC] File Pointer for CHILD's STDIN&STDOUT		*/
char	buf[BUFSIZ];					/* I/O Buffer for STDOUT								*/
int		fd_p2c[2],fd_c2p[2],pid/*,status*/;	/* File Descriptor / Process ID / Status				*/

static int	flag_shellexec=FALS;		/* [STATIC] Shell Exec Flag                       (T/F)	*/

fd_set	r_fds,w_fds,e_fds;				/* File Desc Sets for POLL(2)							*/
struct timeval timeout;					/* Time Out Value for POLL(2)							*/
int		ret;

/* Debug & PreCheck */
	chk_point(ptr);

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( eva_expr(ptr->l,1) ); chk_error(ptr); chk_vtype(x,"S",0);	/* L=>0 */
	y = NULL;
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

	mode = ((tint)(ptr->r))&0xFF;		/* MODE = '!' or '%'									*/

/* Do SHQT()!! */
	if( flag_shellexec == TRUE ){ goto L_SKIP; }
	flag_shellexec = TRUE;

/* Create Pipes & Fork Process */
	if( pipe(fd_p2c)<0 || pipe(fd_c2p)<0 ){ flag_exerr=NullSYS; return(NULL); }
	if( (pid=fork())<0                   ){ flag_exerr=NullSYS; return(NULL); }

/*** CHILD ***/
	if( pid==0 ){

	/* Set STDIN/STDOUT */
		if( dup2(fd_p2c[P_RD],0)<0 ){ flag_exerr=NullSYS; return(NULL); }	/* STDIN_(0) */
		if( dup2(fd_c2p[P_WR],1)<0 ){ flag_exerr=NullSYS; return(NULL); }	/* STDOUT(1) */

	/* Close Pipes */
		if( close(fd_p2c[P_WR])<0 || close(fd_p2c[P_RD])<0 ){ flag_exerr=NullSYS; return(NULL); }
		if( close(fd_c2p[P_WR])<0 || close(fd_c2p[P_RD])<0 ){ flag_exerr=NullSYS; return(NULL); }

	/* Exec Shell */
		execlp("/bin/bash","/bin/bash","-i",NULL);			/* CPU 100% orz */
//		execlp("/bin/bash","/bin/bash",NULL);

	}

/*** PARENT ***/
/* Translate <FD> into <FP> */
	if( (fp_i=fdopen(fd_p2c[P_WR],"w"))==NULL ){ flag_exerr=NullSYS; return(NULL); }
	if( (fp_o=fdopen(fd_c2p[P_RD],"r"))==NULL ){ flag_exerr=NullSYS; return(NULL); }

/* Close Pipes */
	if( close(fd_p2c[P_RD])<0 || close(fd_c2p[P_WR])<0 ){ flag_exerr=NullSYS; return(NULL); }

/* Write Data into CHILD & Leave <FP_I> */
L_SKIP:
	if(fputs(x->str,fp_i)==EOF){ flag_exerr=NullSYS; return(NULL); }
	if(fputs("\n"  ,fp_i)==EOF){ flag_exerr=NullSYS; return(NULL); }	/*** Required!! ***/
	fflush(fp_i);														/*** Required!! ***/

//	if( fclose(fp_i)==EOF ){ flag_exerr=NullSYS; return(NULL); }

/* Read Data from CHILD & Leave <FP_O> */
	while( TRUE ){

	// <FP_O> を監視する
		FD_ZERO(&r_fds);
		FD_ZERO(&w_fds);
		FD_ZERO(&e_fds);

		FD_SET( fileno(fp_o), &r_fds );

	// タイムアウトは 100[ms]
		timeout.tv_sec  = 0;
		timeout.tv_usec = 100*1000;							// Time Out = 100 [ms]

		ret = select( fileno(fp_o)+1, &r_fds, &w_fds, &e_fds, &timeout );
//		ret = select( fileno(fp_o)+1, &r_fds, &w_fds, &e_fds, NULL     );

		if( ret==-1 ) /* SELECT(2) Error   */ { perror("select()"); flag_exerr=NullSYS; return(NULL); }
		if( ret==0  ) /* SELECT(2) TimeOut */ { break; }
		if( fgets(buf,BUFSIZ,fp_o)==NULL )
			break;
		fputs(buf,stdout);
	}

//	if( fclose(fp_o)==EOF ){ flag_exerr=NullSYS; return(NULL); }

/* Wait CHILD & Return */
//	wait(&status);
//	dq=PTR2DOLQ(); dq->type='I'; dq->ival=WEXITSTATUS(status);		/*** Exit Status => $? ***/
	return ans;

}
