/*** ASGN_TM.C ***/						#include	"main.h"

/************************************************************************************************/
// ASGN_TM2DTAB assigns ( C-Lang Struct TM ) P_TM into ( TT-Lang Arry&Hash ) A.
// > Mode: 'A'll  = 0:YEAR / 1:MON / 2:DAY / 3:HOUR / 4:MIN / 5:SEC / 6:WDAY / 7:YDAY / 8:ISDST
// > Mode: 'E'lp  = ****** / ***** / 2:DAY / 3:HOUR / 4:MIN / 5:SEC / ****** / ****** / *******
/************************************************************************************************/
void asgn_tm2dtab(struct tm *p_tm,dtab *a,int mode){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*e;								/* Pointer to Dtab {Arry|Hash} Elmt						*/

/*** 0:YEAR ***/
	if( mode=='A' )
		{ e=ds2p_dtab(a,"year" ); e->type='I'; e->ival=(p_tm->tm_year )+1900; }	/*** ! ***/

/*** 1:MON ***/
	if( mode=='A' )
		{ e=ds2p_dtab(a,"mon"  ); e->type='I'; e->ival=(p_tm->tm_mon  )+   1; }	/*** ! ***/

/*** 2:DAY ***/
	if( mode=='A' || mode=='E' )
		{ e=ds2p_dtab(a,"day"  ); e->type='I'; e->ival=(p_tm->tm_mday );      }

/*** 3:HOUR ***/
	if( mode=='A' || mode=='E' )
		{ e=ds2p_dtab(a,"hour" ); e->type='I'; e->ival=(p_tm->tm_hour );      }

/*** 4:MIN ***/
	if( mode=='A' || mode=='E' )
		{ e=ds2p_dtab(a,"min"  ); e->type='I'; e->ival=(p_tm->tm_min  );      }

/*** 5:SEC ***/
	if( mode=='A' || mode=='E' )
		{ e=ds2p_dtab(a,"sec"  ); e->type='D'; e->dval=(p_tm->tm_sec  );      }	/*** D ***/

/*** 6:WDAY ***/
	if( mode=='A' )
		{ e=ds2p_dtab(a,"wday" ); e->type='I'; e->ival=(p_tm->tm_wday );      }

/*** 7:YDAY ***/
	if( mode=='A' )
		{ e=ds2p_dtab(a,"yday" ); e->type='I'; e->ival=(p_tm->tm_yday );      }

/*** 8:ISDST ***/
	if( mode=='A' )
		{ e=ds2p_dtab(a,"isdst"); e->type='I'; e->ival=(p_tm->tm_isdst);      }
}

/************************************************************************************************/
// ASGN_DTAB2TM assigns ( TT-Lang Arry&Hash ) A into ( C-Lang Struct TM ) P_TM.
// >Mode:'A'll  = 0:YEAR / 1:MON / 2:DAY / 3:HOUR / 4:MIN / 5:SEC / 6:WDAY / 7:YDAY / 8:ISDST
// >Mode:'M'ake = 0:YEAR / 1:MON / 2:DAY / 3:HOUR / 4:MIN / 5:SEC / ****** / ****** / 8:ISDST
// >Mode:'E'lp  = ****** / ***** / 2:DAY / 3:HOUR / 4:MIN / 5:SEC / ****** / ****** / *******
// >Mode:'D'ate = 0:YEAR / 1:MON / 2:DAY / ****** / ***** / ***** / ****** / ****** / *******
// >Mode:'T'ime = ****** / ***** / ***** / 3:HOUR / 4:MIN / 5:SEC / ****** / ****** / *******
/************************************************************************************************/
void asgn_dtab2tm(dtab *a,struct tm *p_tm,int mode){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*e;								/* Pointer to Dtab {Arry|Hash} Elmt						*/

/*** 0:YEAR ***/
	if( mode=='A' || mode=='M' || mode=='D' )
		{ e=ds2p_dtab(a,"year" ); p_tm->tm_year =cint(e)-1900; }	/*** ! ***/

/*** 1:MON ***/
	if( mode=='A' || mode=='M' || mode=='D' )
		{ e=ds2p_dtab(a,"mon"  ); p_tm->tm_mon  =cint(e)-   1; }	/*** ! ***/

/*** 2:DAY ***/
	if( mode=='A' || mode=='M' || mode=='E' || mode=='D' )
		{ e=ds2p_dtab(a,"day"  ); p_tm->tm_mday =cint(e);      }

/*** 3:HOUR ***/
	if( mode=='A' || mode=='M' || mode=='E' || mode=='T' )
		{ e=ds2p_dtab(a,"hour" ); p_tm->tm_hour =cint(e);      }

/*** 4:MIN ***/
	if( mode=='A' || mode=='M' || mode=='E' || mode=='T' )
		{ e=ds2p_dtab(a,"min"  ); p_tm->tm_min  =cint(e);      }

/*** 5:SEC ***/
	if( mode=='A' || mode=='M' || mode=='E' || mode=='T' )
		{ e=ds2p_dtab(a,"sec"  ); p_tm->tm_sec  =cint(e);      }	/*** D ***/

/*** 6:WDAY ***/
	if( mode=='A' )
		{ e=ds2p_dtab(a,"wday" ); p_tm->tm_wday =cint(e);      }

/*** 7:YDAY ***/
	if( mode=='A' )
		{ e=ds2p_dtab(a,"yday" ); p_tm->tm_yday =cint(e);      }

/*** 8:ISDST ***/						/* If UNDEF()ed, ISDST will become FALS.				*/
	if( mode=='A' || mode=='M' )
		{ e=ds2p_dtab(a,"isdst"); p_tm->tm_isdst=istrue(e);    }
}
