/*** BSUP.C - Bison(1) Support Code in C-Lang ***/

/* Define Macro(s) for BISON */
#define	b(MSG)		if( flag_debug&DF_BISON ){ eprin("[%sBp%s] %s\n", C_RED(2), C_DEF(2), MSG); }

#define	new_glcdx(NAM)		idx2cdx('G',wr_dtab(GL_DTAB        ,NAM,'U',0))
#define	new_stcdx(NAM)		idx2cdx('S',wr_dtab(mp_base+ST_DTAB,NAM,'U',0))
#define	new_lccdx(NAM)		idx2cdx('L',wr_dtab(mp_base+LC_DTAB,NAM,'U',0))
#define	opeq(OPEQ,OP,LC,RC)	mk_ctree('=',tkpos(OPEQ),LC,mk_ctree(OP,tkpos(OPEQ),LC,RC,00),00);

#define	deptk(ARG)			(ARG.name),(ARG.file),(ARG.line),(ARG.colm),(ARG.gl),(ARG.st),(ARG.lc),(ARG.p_elmt)
#define	tkpos(ARG)			(ARG.              file),(ARG.              line),(ARG.              colm)
#define	ctpos(ARG)			(ARG==NULL?00:ARG->file),(ARG==NULL?00:ARG->line),(ARG==NULL?00:ARG->colm)

/************************************************************************************************/
// ISCGAP() check CTREE Node is <GAP>. (TRUE/FALS)
/************************************************************************************************/
int iscgap(ctree *node){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	return( (node->op==0x00||node->op==0xFF) && node->x==NULL );
}

/************************************************************************************************/
// LGAP() check and return <GAP> Node index in CTREE CSL. ( Index=0,1,2,... / NonGAP=INVA )
/************************************************************************************************/
int lgap(ctree *ctr){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		cnt = lcnt(ctr);
	for( int i=0 ; i<cnt ; i++ )
		if( iscgap(lptr(ctr,i)) ){ return(i); }
	return(INVA);
}

/************************************************************************************************/
// LCNT()|LCNTA()|LCNTG() return node count in { CTREE CSL | Argv CSL | Generic CTREE }.
/************************************************************************************************/
int lcnt (ctree *ctr){					/* Node Count in CTREE CSL								*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( ctr==NULL ){ return 0x00; }		/* ( No Node ) */
	if( ctr->op==',' )
		return( lcnt(ctr->l) + lcnt(ctr->r) );
	return(1);
}

int lcnta(ctree *ctr){					/* Node Count in Argv CSL ( Allow Root OP )				*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		lc,rc;
	if( ctr==NULL ){ return 0x00; }		/* ( No Node ) */
	if( ctr->op==0x00 || ctr->op==0xFF )
		return 1;
	if( ctr->l ==NULL && ctr->r ==NULL )
		return 1;
	lc = (ctr->l==NULL) ? 0 : (ctr->l->op==','?lcnta(ctr->l):1);
	rc = (ctr->r==NULL) ? 0 : (                              1);
	return( lc + rc );
}

int lcntg(ctree *ctr){					/* Node Count in Generic CTREE							*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( ctr==NULL ){ return 0x00; }		/* ( No Node ) */
	if( ctr->op!=0x00 && ctr->op!=0xFF )
		return( lcntg(ctr->l) + lcntg(ctr->r) );
	return(1);
}

/************************************************************************************************/
// LPTR()|LPTRA()|LPTRG() return node pointer in { CTREE CSL | Argv CSL | Generic CTREE }.
/************************************************************************************************/
ctree *lptr (ctree *ctr,int idx){		/* Node Pointer in CTREE CSL							*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		lc;								/* >Left Node Count										*/
	if( ctr==NULL ){ return NULL; }		/* ( No Node ) */
	if( ctr->op==',' ){
		lc=lcnt (ctr->l); return((idx<=lc-1) ? lptr (ctr->l,idx) : lptr (ctr->r,idx-lc));
	}
	return( idx==0 ? ctr : NULL );
}

ctree *lptra(ctree *ctr,int idx){		/* Node Pointer in Argv CSL ( Allow Root OP )			*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		lc,rc;							/* >Left&Right Node Count								*/
	if( ctr==NULL ){ return NULL; }		/* ( No Node ) */
	if( ctr->op==0x00 || ctr->op==0xFF )
		return( idx==0?ctr:NULL );
	rc = (ctr->r==NULL?0:1);
	lc = lcnta(ctr) - rc;
	if( idx<lc+rc-1 ){
		if( lc==1 ) return( idx==0 ? ctr->l : NULL );
		else return( lptra(ctr->l,idx) );
	}
	if( idx==lc+rc-1 ){
		if( rc==1 ) return( ctr->r );
		else return( lc==1 ? ctr->l : ctr->l->r );
	}
	return(NULL);
}

ctree *lptrg(ctree *ctr,int idx){		/* Node Pointer in Generic CTREE						*/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		lc;								/* >Left Node Count										*/
	if( ctr==NULL ){ return NULL; }		/* ( No Node ) */
	if( ctr->op!=0x00 && ctr->op!=0xFF ){
		lc=lcntg(ctr->l); return( idx<=lc-1 ? lptrg(ctr->l,idx) : lptrg(ctr->r,idx-lc) );
	}
	return( idx==0?ctr:NULL );
}

/************************************************************************************************/
// MK_CTREE() make new CTREE       Node, and return its pointer.
// MK_CLEAF() make new CTREE CLEAF Node, and return its pointer. ( OP={0x00|0xFF},L=NULL,R=NULL )
// MK_CGAP () make new CTREE <GAP> Node, and return its pointer.
/************************************************************************************************/
ctree *mk_ctree(int op,int file,int line,int colm,ctree *el,ctree *er,ctree *ex){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
ctree	*node = X_MALL(sizeof(ctree));			/* Alloc CTREE Node								*/
	node->op   = op;
	node->file = file;
	node->line = line;
	node->colm = colm;
	node->init = FALS;
	node->l = (el);  node->r = (er);  node->x = (ex);
	if( flag_debug&DF_CTRDP ){ msg_y("MK_CTREE()"); dump_ct((tint)node,0); }
	return(node);
}

ctree *mk_cleaf(int op,int file,int line,int colm,tint cdx){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	return mk_ctree(op,file,line,colm,00,00,(void*)cdx);
}

ctree *mk_cgap(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	return mk_ctree(00,00,00,00,00,00,00);
}

/************************************************************************************************/
// DG_CTREE() connect E2 to the last node of E1 link list, and return its head (E1).
/************************************************************************************************/
ctree *dg_ctree(ctree *e1,ctree *e2){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
ctree	*node = e1;
	while( node->x!=NULL )						/* Move to the Last CTREE Node					*/
		node = node->x;
	node->x = e2;								/* Connect to IT								*/
	return(e1);
}

/************************************************************************************************/
// EXT_CTRDTAB    () make new CLEAF + new external DTAB    . ( PTR is used as Line&Colm Refs.)
// EXT_CTRDTABMULT() make new CLEAF + new external DTAB CSL. ( PTR is used as Line&Colm Refs.)
/************************************************************************************************/
ctree *ext_ctrdtab(ctree *ptr){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*ext = X_MALL(sizeof(dtab));
	init_dtab(ext);
	ext->name = X_SDUP("(extn)");
	return mk_cleaf( 0xFF, ctpos(ptr), (tint)ext );
}

ctree *ext_ctrdtabmult(ctree *ptr,int n){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
ctree *node=ext_ctrdtab(ptr);
	for( n=n-1 ; n>0 ; n-- )
		node = mk_ctree( ',', ctpos(ptr), node, ext_ctrdtab(ptr), NULL );
	return(node);
}

/************************************************************************************************/
// INST_FPARAM() install DTAB into LC_DTAB for (UsrDef)Func Param.
// INST_STRUID() install DTAB              for STID. ( external )
/************************************************************************************************/
ctree *inst_fparam(char *name,int file,int line,int colm,int fg,int fs,int fl,ctree *p_elmt){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
tint	cdx = new_lccdx(name); b("(Fpara/LC) - New!!");
	return mk_cleaf(0x00,file,line,colm,(tint)cdx);
}

ctree *inst_struid(char *name,int file,int line,int colm,int fg,int fs,int fl,ctree *p_elmt){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*ext = X_MALL(sizeof(dtab)); init_dtab(ext); ext->name = X_SDUP(name);
	ext->type='S';
	ext->str =X_SDUP(name);				// It seems funny, but required by mk_ukey().
	return mk_cleaf(0xFF,file,line,colm,(tint)ext);
}

/************************************************************************************************/
// LKINST_LPARAM() lookup or install DTAB in DestDTAB for LVAL.  ( If ScopeFlag==ON it will
// install. / If ScopeFlag==OFF it will lookup or install. )  Then it return pointer to CTREE.
// Note: It's Scan&Parse Phase!!  We must access Orig DTAB!!
/************************************************************************************************/
ctree *lkinst_lparam(char *name,int file,int line,int colm,int fg,int fs,int fl,ctree *p_elmt){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		idx,cdx,chr='*';				/* Scope Char 'G'/'L'/'S' or '*' => N/A					*/
dtab	*p_dtab;		ctree	*p_cnew;

/*** ScopeFlag==ON: Install & Return ***/
	if( fg>0 || fs>0 || fl>0 ){
	/* >STATIC on TopLelev ( STATIC -> LOCAL ) */
		if( fs>0 && mp_base==GL_DTAB ){ fl=fs; fs=0; }
	/* >Check Conflict */
/*----------------------------------------------------------------------------------------------*/
// 例外処理：明示的な GL 指定有り、かつ、LookUp結果が関数であった場合は、当該関数をLookUpする。
// -> 目的：明示的な GL 関数の上書きによる、明示的な GL 変数の生成を実現する為。
/*----------------------------------------------------------------------------------------------*/
		if( ((fg>0        ) &&                     (idx=rd_dtab(GL_DTAB        ,name))!=INVA) ){
			p_dtab = cdx2p_dtab( cdx=idx2cdx('G',idx) );
			if( p_dtab->type=='X' )								// Special Case!!
				goto L_RETN;
		}
		if( ((fg>0        ) &&                     (idx=rd_dtab(GL_DTAB        ,name))!=INVA) ||\
			((fs>0 || fl>0) && mp_base!=GL_DTAB && (idx=rd_dtab(mp_base+ST_DTAB,name))!=INVA) ||\
			((fs>0 || fl>0) &&                     (idx=rd_dtab(mp_base+LC_DTAB,name))!=INVA) ){
			msg_r("Master!! - cannot define variable %s (collision) %s",name,sloc(file,line));
			flag_exerr = E_PARSER; return(NULL);
		}
	/* >Install DTAB */
		if( fg>0 ){ cdx=new_glcdx(name); b("(Lpara/GL) - New!!"); }
		if( fs>0 ){ cdx=new_stcdx(name); b("(Lpara/ST) - New!!"); }
		if( fl>0 ){ cdx=new_lccdx(name); b("(Lpara/LC) - New!!"); }
	/* Return CTREE */
L_RETN:
		p_cnew = mk_cleaf(0x00,file,line,colm,cdx);
		if( p_elmt!=NULL )				/*** Scan&Parse Phase => Set Orig_DTAB ***/
			{ cdx2p_orig(cdx)->attr |= (p_elmt->op==STID ? ATTR_STID:0x00); }
		while( p_elmt!=NULL ){
			p_cnew = mk_ctree(p_elmt->op,p_elmt->file,p_elmt->line,p_elmt->colm,p_cnew,p_elmt->r,NULL);
			p_elmt = p_elmt->x;
		}
		return p_cnew;
	}

/*** ScopeFlag==OFF: LookUp|Install & Return ***/
/* LookUp DTAB (LC->ST->GL) */
	if( chr=='*' &&                     (idx=rd_dtab(mp_base+LC_DTAB,name))!=INVA ){ chr='L'; }
	if( chr=='*' && mp_base!=GL_DTAB && (idx=rd_dtab(mp_base+ST_DTAB,name))!=INVA ){ chr='S'; }
	if( chr=='*' &&                     (idx=rd_dtab(GL_DTAB        ,name))!=INVA ){ chr='G'; }

	p_dtab = ( chr=='*' ? NULL : cdx2p_dtab(idx2cdx(chr,idx)) );

/* Install DTAB (LC) */
/*----------------------------------------------------------------------------------------------*/
// 例外処理：ScopeFlag無し、かつ、LookUp結果が関数のみであった場合は、LC にインストールする。
// -> 目的：意図しない関数の上書きと、意図しない GL 変数の生成を防止する為。
/*----------------------------------------------------------------------------------------------*/
	if( chr=='*' || ( chr=='G' && p_dtab->type=='X' ) ){		// Not Found!! || Special Case!!
		cdx=new_lccdx(name); b("(Lpara/LC) - New!!");
	}
	else														// Found!!
		cdx=idx2cdx(chr,idx);

/* Return CTREE */
	p_cnew = mk_cleaf(0x00,file,line,colm,cdx);
	if( p_elmt!=NULL )
		{ cdx2p_orig(cdx)->attr |= (p_elmt->op==STID ? ATTR_STID:0x00); }	/*** Scan&Parse Phase => Set Orig_DTAB ***/
	while( p_elmt!=NULL ){
		p_cnew = mk_ctree(p_elmt->op,p_elmt->file,p_elmt->line,p_elmt->colm,p_cnew,p_elmt->r,NULL);
		p_elmt = p_elmt->x;
	}
	return p_cnew;
}

/************************************************************************************************/
// LKINST_RPARAM() lookup DTAB from LC->ST->GL or install DTAB into LC for RVAL.
// Then it return pointer to CTREE.  Scope Flag never affect them, because it's RVAL.
// Note: It's Scan&Parse Phase!!  We must access Orig DTAB!!
/************************************************************************************************/
ctree *lkinst_rparam(char *name,int file,int line,int colm,int fg,int fs,int fl,ctree *p_elmt){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		idx,cdx,chr='*';				/* Scope Char 'G'/'L'/'S' or '*' => N/A					*/
dtab	*p_dtab;		ctree	*p_cnew;

/* LookUp DTAB (LC->ST->GL) */
	if( chr=='*' &&                     (idx=rd_dtab(mp_base+LC_DTAB,name))!=INVA ){ chr='L'; }
	if( chr=='*' && mp_base!=GL_DTAB && (idx=rd_dtab(mp_base+ST_DTAB,name))!=INVA ){ chr='S'; }
	if( chr=='*' &&                     (idx=rd_dtab(GL_DTAB        ,name))!=INVA ){ chr='G'; }

	p_dtab = ( chr=='*' ? NULL : cdx2p_dtab(idx2cdx(chr,idx)) );

/* Install DTAB (LC) */
	if( chr=='L' || chr=='S' || chr=='G' )		// Found!!
		cdx=idx2cdx(chr,idx);
	else{										// Not Found!!
		cdx=new_lccdx(name); b("(Rpara/LC) - New!!");
	}

/* Return CTREE */
	p_cnew = mk_cleaf(0x00,file,line,colm,cdx);
	if( p_elmt!=NULL )
		{ cdx2p_orig(cdx)->attr |= (p_elmt->op==STID ? ATTR_STID:0x00); }	/*** Scan&Parse Phase => Set Orig_DTAB ***/
	while( p_elmt!=NULL ){
		p_cnew = mk_ctree(p_elmt->op,p_elmt->file,p_elmt->line,p_elmt->colm,p_cnew,p_elmt->r,NULL);
		p_elmt = p_elmt->x;
	}
	return p_cnew;
}

/************************************************************************************************/
// LKINST_FNAM4DEFX() lookup DTAB from GL or install DTAB into GL for FNAM (DEFX).
// Then it returns pointer to CTREE.  Scope Flag never affect them, because it's FNAM.
// Note: It will adjust iCPU!!  It's Scan&Parse Phase!!  We must access Orig DTAB!!
/************************************************************************************************/
ctree	*lkinst_fnam4defx(char *name,int file,int line,int colm,int fg,int fs,int fl,ctree *p_elmt){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		idx,_idx,cdx,_cdx,chr='*',addr;	/* Scope Char 'G'/'L'/'S' or '*' => N/A					*/
dtab	*p_dtab,*_p_dtab;
ctree	*p_cnew;

/* LookUp|Install DTAB [GL|GL] */
	if( chr=='*' &&                     (idx=rd_dtab(GL_DTAB        ,name))!=INVA ){ chr='G'; }

/* Install DTAB (GL) */
	if( chr=='L' || chr=='S' || chr=='G' ){		// Found!!
		cdx=idx2cdx(chr,idx); p_dtab=cdx2p_dtab(cdx);

// 既存 {SysDef|UsrDef} 関数を再定義する場合は、旧関数 FNAM() を _FNAM() にバックアップしてから、
// 新関数 FNAM() を上書きインストールします。ただし、名前 _FNAM() が衝突する場合は、バックアップ
// の作成は行なわれません。なお、前方参照関数の事後定義については、ここの処理には含まれません。

		if( p_dtab->type=='X' && !(((p_dtab->attr)&ATTR_FXID)==0 && p_dtab->ptr==NULL) ){
			b("!!! Make BackUp as _FNAM() && OverWrite FNAM() !!!");
		/* BackUp FNAME() as _FNAME() if possible */
			if( (_idx=rd_dtab(GL_DTAB,X_SCAT("_",name)))==INVA ){			// _FNAM() is Empty !!
			/* >BackUp GL_DTAB */
				_idx = wr_dtab(GL_DTAB,X_SCAT("_",name),'X',0);
				_cdx = idx2cdx('G',_idx); _p_dtab = cdx2p_dtab(_cdx);
				cpy_dtab( _p_dtab , p_dtab );
			/* >Modify MEM[]   */
				if( (_p_dtab->attr)&ATTR_FXID )								// (UsrDef)Func()
					mem[ GL_DTAB + ((_p_dtab->attr)&ATTR_FXID)*FX_UNIT + FX_INFO ] = (void *)(tint)_cdx;
			}
		}

// 既存グローバル変数への上書きをする場合は、そのまま新関数 FNAM() を上書きインストールします。
// なお、前方参照関数の事後定義についても、ここの処理に含まれます。

		else
			b("!!! OverWrite Data || Install Forward Reference FNAM() !!!");

	}
	else{										// Not Found!!
		cdx=new_glcdx(name); b("Install FNAM [GL] for DEFX - New!! *** Adjust iCPU ***");
	}

/* Calc FuncAddr && Adjust iCPU */
	for( addr=GL_DTAB+FX_UNIT ; addr<IMEM_SIZE ; addr+=FX_UNIT ){
		if( mem[addr+FX_INFO]==NULL )			// W/O CDX => Empty MEM[]
			break;
	} assert( addr<IMEM_SIZE );
	fx      = (addr-GL_DTAB)/FX_UNIT;
	mp_base = GL_DTAB + fx*FX_UNIT;
	while( mp<=mp_base ){ mp += FX_UNIT; chk_overflow(); }

/* SetUp DTAB */
	p_dtab = cdx2p_dtab(cdx);
	init_dtab(p_dtab);
	p_dtab->type = 'X';					/* We will install (UsrDef)FNAM() !! */
	p_dtab->attr = fx;					/* We will install (UsrDef)FNAM() !! */

/* MakeUp&Return CTREE */
	p_cnew = mk_cleaf(0x00,file,line,colm,cdx);
	return p_cnew;
}

/************************************************************************************************/
// LKINST_FNAM4CALL() lookup DTAB from LC+ST+GL or install DTAB into GL for FNAM (CALL).
// Then it returns pointer to CTREE.  Scope Flag never affect them, because it's FNAM.
// Note: It's Scan&Parse Phase!!  We must access Orig DTAB!!
/************************************************************************************************/
ctree	*lkinst_fnam4call(char *name,int file,int line,int colm,int fg,int fs,int fl,ctree *p_elmt){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		idx,cdx,chr='*';				/* Scope Char 'G'/'L'/'S' or '*' => N/A					*/
dtab	*p_dtab;
ctree	*p_cnew;

/* LookUp|Install DTAB [LC->ST->GL|GL] */
	if( chr=='*' &&                     (idx=rd_dtab(mp_base+LC_DTAB,name))!=INVA ){ chr='L'; }
	if( chr=='*' && mp_base!=GL_DTAB && (idx=rd_dtab(mp_base+ST_DTAB,name))!=INVA ){ chr='S'; }
	if( chr=='*' &&                     (idx=rd_dtab(GL_DTAB        ,name))!=INVA ){ chr='G'; }

	if( chr=='L' || chr=='S' || chr=='G' )		// Found!!
		cdx=idx2cdx(chr,idx);
	else{										// Not Found!!
		cdx=new_glcdx(name); b("Install FNAM [GL] for CALL - New!!");
		p_dtab = cdx2p_dtab(cdx);		/* GL_DTAB == Orig DTAB									*/
		p_dtab->type = 'X';				/* Fowrward Reference!! [ (UsrDef)Func() ]				*/
	}

/* MakeUp&Return CTREE [ FYI: Func() can be a Arry Elmt ] */
	p_cnew = mk_cleaf(0x00,file,line,colm,cdx);
	if( p_elmt!=NULL )					/*** Scan&Parse Phase => Set Orig_DTAB ***/
		{ cdx2p_orig(cdx)->attr |= (p_elmt->op==STID ? ATTR_STID:0x00); }
	while( p_elmt!=NULL )
		{ p_cnew = mk_ctree(p_elmt->op,p_elmt->file,p_elmt->line,p_elmt->colm,p_cnew,p_elmt->r,NULL); p_elmt = p_elmt->x; }
	return p_cnew;
}
